#version 120

#include "/settings.glsl"

uniform int isEyeInWater;

in vec2 TexCoords;
uniform sampler2D colortex0;
uniform sampler2D colortex3;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;

#if FOG == 1
uniform float near, far;
uniform float blindness;
uniform float darknessFactor;
uniform vec3 fogColor;
uniform int worldTime;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
	vec4 homPos = projectionMatrix * vec4(position, 1.0);
	return homPos.xyz / homPos.w;
}

float smoothTransition(float time) {
    if (time >= 0.0f && time <= 1000.0f) {
        return time / 1000.0f; // Transition from 0 to 1
    } else if (time > 1000.0f && time < 12000.0f) {
        return 1.0f; // Fully enabled
    } else if (time >= 12000.0f && time <= 13000.0f) {
        return 1.0f - (time - 12000.0f) / 1000.0f; // Transition from 1 to 0
    } else {
        return 0.0f; // Fully disabled
    }
}
#endif

void main() {
	vec3 color = texture2D(colortex0, TexCoords).rgb;
	
	#ifdef DISTANT_HORIZONS
	#else
	#if FOG == 1
	float normal = texture2D(colortex3, TexCoords).x;
	float depth0 = texture2D(depthtex0, TexCoords).r;
	float depth1 = texture2D(depthtex1, TexCoords).r;
	
	if(depth1 == 1 && normal == 0) {
		/*DRAWBUFFERS:0*/
		gl_FragData[0] = vec4(color, 1.0f);
		return;
	}
	
	vec3 NDCPos = vec3(TexCoords.xy, depth0) * 2.0 - 1.0;
	vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
	
	float farW = far;
	float distW = FOG_DISTANCE;
	
	if(isEyeInWater == 1) {
		farW = 16;
		distW = 1;
	}
	
	float distance = length(viewPos) / (farW * mix(mix(1, near * 0.5, blindness), near, darknessFactor));
	float fogFactor = exp(-mix(distW, 1, blindness) * (1.0 - distance));
	
	vec3 color_sky;
	#if TI == 0
	#if GREY_WEATHER == 0
	color_sky = fogColor;
	#else
	float state = smoothTransition(worldTime);
	color_sky = mix(fogColor, vec3(0.75, 0.75, 0.76), state);
	#endif
	#else
	float state = smoothTransition(worldTime);
	color_sky = pow(mix(vec3(0.0005), vec3(0.18), state), vec3(1.0f / 2.2f));
	#endif
	
	color = mix(color, pow(color_sky, vec3(2.2f)), clamp(fogFactor, 0.0, 1.0));
	#endif
	#endif
	
	/*DRAWBUFFERS:0*/
	gl_FragData[0] = vec4(color, 1.0f);
}
