#include "lib/Version.glsl"

const bool colortex0MipmapEnabled = true;
const bool colortex4MipmapEnabled = true;

#include "lib/Common.glsl"
#include "lib/TextureIncludes.glsl"

uniform float viewWidth;
uniform float viewHeight;
uniform float near;
uniform float far;
uniform vec3 fogColor;
uniform float rainStrength;
uniform int isEyeInWater;

uniform int heldItemId;

uniform int heldBlockLightValue;

in vec2 texCoord;

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 outColor0;

#define USE_TORCH true //[false true]
#define TORCH_BRIGHTNESS 2.0 //[1.0 2.0 3.0 4.0 5.0]
#define TORCH_DISTANCE 4.0 //[0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

#define USE_HELD_ITEM_LIGHT_VALUE true //[false true]
#define MINIMUM_HELD_ITEM_LIGHT_VALUE 14 //[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]

#define TORCH_COLOUR_R 256 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256]
#define TORCH_COLOUR_G 256 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256]
#define TORCH_COLOUR_B 256 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256]

#define USE_ITEM_ID false //[false true]
#define ITEM_ID_FOR_TORCH 0 //[0 1 2 3 4 5 6 7 8 9 10]

#define SKY_FOG_DENSITY 100.0 //[0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0]
#define RAIN_FOG_DENSITY 50.0 //[0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0]
#define WATER_FOG_DENSITY 25.0 //[0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0]
#define LAVA_FOG_DENSITY 5.0 //[0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0]

void main()
{
    vec4 inputColour = texture(colortex0, texCoord);
    float depth = texture(depthtex0, texCoord).r;
    float linDepth = linearizeDepth(depth, near, far);

    if(USE_TORCH && ((heldBlockLightValue >= MINIMUM_HELD_ITEM_LIGHT_VALUE && USE_HELD_ITEM_LIGHT_VALUE) || (USE_ITEM_ID && heldItemId == ITEM_ID_FOR_TORCH)))
    {
        vec2 fragCoord = texCoord * vec2(viewWidth, viewHeight);
        vec2 lightCoord = (fragCoord - 0.5 * vec2(viewWidth, viewHeight)) / viewHeight;

        float spotLight = texture(colortex6, lightCoord - 0.5).r;
        if(abs(lightCoord.x) > 0.5 || abs(lightCoord.y) > 0.5)
            spotLight = 0.0;
        spotLight *= saturate(1.0 - pow(linDepth, 0.5) / TORCH_DISTANCE);

        vec3 torchCol = mix(vec3(0.0), texture(colortex4, texCoord).rgb * (vec3(TORCH_COLOUR_R, TORCH_COLOUR_G, TORCH_COLOUR_B) / 256.0) * TORCH_BRIGHTNESS, spotLight);
        inputColour.rgb = saturate(inputColour.rgb + torchCol);
    }

    float density = SKY_FOG_DENSITY;
    density = mix(density, RAIN_FOG_DENSITY, rainStrength);
    if(isEyeInWater == 1)
    {
        density = WATER_FOG_DENSITY;
    }
    else if(isEyeInWater == 2)
    {
        density = LAVA_FOG_DENSITY;
    }

    if(linDepth >= far)
        density = 100000.0;

    vec3 worldPos = WorldPositionFromDepth(depth, texCoord);
    float worldDepth = 1.0 - exp(-length(worldPos) / density);
    inputColour.rgb = mix(inputColour.rgb, fogColor, worldDepth);

    outColor0 = inputColour;
}