#version 120

#define lines
#define animatedLines 1.0 // [0.0 1.0]
#define lineStrength 2.0 // [1.2 1.4 1.6 1.8 2.0 2.2 2.4 2.6 2.8 3.0]
#define direction 2.0 // [1.0 2.0]
//directions: 1.0 (left right) 2.0 (up down)
#define lineDensity 1.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 7.9]
#define grunge
#define blur 0.0 // [0.0 1.0 2.0 3.0 4.0 5.0 6.0]
#define sharp
#define sharpness 2.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

varying vec2 uv;
uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform int frameCounter;

float rand(vec2 v){
    return fract(sin(dot(v, vec2(12.9898f, 78.233f))) * 43758.5453f);
}

void main() {
    vec2 uv2 = uv;
    float r = rand(uv);
    float depth = texture2D(depthtex0, uv).r;

    #ifdef sharp 
        vec2 blur_uv = uv;
        blur_uv.x += r * 0.005f;
        blur_uv.y += r * 0.005f;
        vec3 original = texture2D(colortex0, uv2).rgb;
        vec3 blurred = texture2D(colortex0, blur_uv).rgb;
        original = original + (original - blurred) * sharpness;
    #endif

    #ifdef blur
        uv2.x += r * depth * (blur * 0.001f);
        uv2.y += r * depth * (blur * 0.001f);
    #endif

    vec3 color = texture2D(colortex0, uv2).rgb;
    
    #ifdef sharp
    color = original;
    #endif
    //color = vec3(depth);

    #ifdef lines
    float random; 
    if(direction == 1.0) {
        random = rand(vec2(gl_FragCoord.y, frameCounter * animatedLines));
    } else {
        random = rand(vec2(gl_FragCoord.x, frameCounter * animatedLines));
    }

    if(random > 0.92 + lineDensity * 0.01f) {
        color *= lineStrength;
    }
    #endif

    #ifdef grunge
        if(rand(uv) > 0.99f) {
            color *= 2;
        }
    #endif
    
    gl_FragColor = vec4(color, 1.0f);
}