#version 120

#define colordistort
#define colordistort_strength 0.05 // [0.05 0.06 0.07 0.08 0.09 0.1 0.12 0.14 0.16 0.18 0.2]
#define desat 0.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9] 
#define Wave
#define Wave_Strength 0.0 // [0.0 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0]

varying vec2 uv;
uniform sampler2D colortex0;
uniform int frameCounter;
uniform float viewWidth, viewHeight;

vec3 randColor(vec3 v) {
    float random = sin(frameCounter);

    v.r = fract(sin(dot(uv + v.r + v.b + random, vec2(12.9898, 78.233))) * 43758.5453);
    v.g = fract(sin(dot(uv + v.g + v.r + random, vec2(12.9898, 78.233))) * 43758.5453);
    v.b = fract(sin(dot(uv + v.b + v.g + random, vec2(12.9898, 78.233))) * 43758.5453);
    return v;
}

void main() {
    vec2 uv2 = uv;
    #ifdef Wave
    float rand = fract(sin(dot(uv * 0.1 + uv.y, vec2(12.9898, 78.233))) * 43758.5453); 
    float height = viewHeight;

    uv2.x += sin(uv2.y * (height * 0.1)) / height * (Wave_Strength / 2 + sin(dot(vec2(uv.y + uv.x), vec2(12.9898, 78.233)) + ceil(rand)));
    
    #endif

    vec4 color = texture2D(colortex0, uv2).rgba;

    #ifdef colordistort
        color.rgb = mix(randColor(color.rgb), color.rgb, 1.2 - colordistort_strength);
    #endif

    vec3 grayscale = vec3(color.r + color.g + color.b) / 3.5f;
    color.rgb = mix(color.rgb, grayscale, desat); // values bigger mean more desaturation 

    gl_FragColor = color;
}

//sin(uv2.y * (viewHeight * 0.1) - rand + frameCounter * 0.05) / viewHeight * Wave_Strength;