#version 120

#define flicker
#define flickerstrength 1.0 // [0.5 0.75 1.0 1.25 1.5 1.75 2.0]
#define brightness 1.0 // [-5.0 -4.0 -3.0 -2.0 -1.0 1.0 2.0 3.0 4.0 5.0]

varying vec2 uv;
uniform sampler2D colortex0;
uniform int frameCounter;

float rand(vec2 v){
    return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
    vec3 color = texture2D(colortex0, uv).rgb;
    if(brightness > 0.0) {
        color *= brightness;
    } else {
        color /= abs(brightness);
    }
    
    #ifdef flicker
        color = mix(color, vec3(0.0, 0.0, 0.0), (rand(vec2(sin(frameCounter) * 0.5, 0.0))) * (flickerstrength * 0.1));
    #endif

    gl_FragColor = vec4(color, 1.0f);
}