#version 120

#define Noise 0.0 // [0.0 1.0]
#define Noise_Strength 4.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0]
#define Scan_Lines 1.0 // [0.0 1.0]
#define Scan_Lines_Strength 1.05 // [1.05 1.1 1.15]
#define Scan_Lines_Count 500 // [500 600 700 800 900 1000]

varying vec2 uv;

uniform sampler2D colortex0;
uniform int frameCounter;

float rand(vec2 v){
    return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453);
}

void main () { 
    vec3 color = texture2D(colortex0, uv).rgb;

    if(Noise == 1.0) {
        color = mix(color, vec3(0.0, 0.0, 0.0), rand(uv + vec2(frameCounter, uv.y * (uv.x + sin(uv.x)))) / Noise_Strength);
    }

    if(Scan_Lines == 1.0) {
	    vec2 vec = vec2(sin(uv.y * Scan_Lines_Count), cos(uv.y * Scan_Lines_Count));
	    gl_FragColor = mix(vec4(vec.xyx, texture2D(colortex0, uv).a), vec4(color, 1.0), ((Scan_Lines_Strength * 0.1) * 2) * 5);
    } else {
        gl_FragColor = vec4(color, 1.0);
    }
    
}