#version 120

varying vec2 uv;

uniform sampler2D colortex0;

#define Chromatic_Aberration 2.0 // [0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]
#define vignette
#define vignetteStrength 1.0 // [1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0]

void main () {
    vec3 color;
    vec3 original = texture2D(colortex0, uv).rgb;
    color.r = texture2D(colortex0, vec2(uv.x + Chromatic_Aberration * 0.001, uv.y)).r;
    color.g = texture2D(colortex0, uv).g;
    color.b = texture2D(colortex0, vec2(uv.x - Chromatic_Aberration * 0.001 , uv.y)).b;

    #ifdef vignette
        vec2 c = uv - vec2(0.5, 0.5);
		color = mix(color, vec3(1.0 - vignetteStrength), dot(c, c));
    #endif

    gl_FragColor = vec4(color, 1.0);
}