#version 120

#define auto_exp
#define exp_speed 8.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0]

varying vec2 uv;
uniform sampler2D colortex0;
uniform ivec2 eyeBrightnessSmooth;

const float eyeBrightnessHalflife = exp_speed;

float rand(vec2 v){
    return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
    vec3 color = texture2D(colortex0, uv).rgb;

    #ifdef auto_exp
    float totalBrightness = eyeBrightnessSmooth.x + eyeBrightnessSmooth.y;

    if(totalBrightness < 100.0 + rand(uv) * 10.0f) {
        color -= totalBrightness * 0.001f;
    } else {
        color *= totalBrightness * 0.0025f;
    }
    #endif
    
    
    gl_FragColor = vec4(color, 1.0f);
}