#version 120

#define pixel
#define pixel_strength 3.0 // [0.5 0.6 0.7 0.8 0.9 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0]
#define grain_artifact

varying vec2 uv;
uniform float viewWidth, viewHeight;

uniform sampler2D colortex0;
uniform int frameCounter;

float rand(vec2 v){
    return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
    vec2 uv2 = uv;
    
    #ifdef pixel
        float pixels = viewWidth * pixel_strength + viewHeight * pixel_strength;
        float x = 5.0 * (1.0 / pixels);
        float y = 5.0 * (1.0 / pixels);

        uv2 = vec2(x * floor(uv.x / x), y * floor(uv.y / y));
    #endif

    vec3 color = texture2D(colortex0, uv2).rgb;

    #ifdef grain_artifact
        float g = rand(vec2(frameCounter * uv.x, uv.y + uv.x + uv.y / uv.x));
        if(g > 0.995f) {
            color *= 4.7;
        }
        
    #endif
    

    gl_FragColor = vec4(color, 1.0f);
}