#version 120

uniform sampler2D lightmap;
uniform sampler2D texture;
uniform sampler2D depthtex0;

uniform vec4 entityColor;
uniform int frameCounter;
uniform float viewWidth;
uniform float viewHeight;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;

void main() {
	vec4 color = texture2D(texture, texcoord) * glcolor;
	color.rgb = mix(color.rgb, entityColor.rgb, entityColor.a);
	color *= texture2D(lightmap, lmcoord);

    gl_FragDepth = gl_FragCoord.z;

    /* DRAWBUFFERS:3 */
    gl_FragData[0] = color; //gcolor   
}