#version 120

varying vec2 uv;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex5;

uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;

#define DotSize 2 // [1 2 3 4 5 6 7 8 9 10]
#define Celshade

// this celshading code is fully lifted from Sildur's shaders -- all credit goes to them
#define OutlineSize 1 // [1 1.2 1.4 1.6 1.8 2.0 2.2 2.4 2.6 2.8 3.0]
#define Celradius 1

float edepth(vec2 coord) {
	return texture2D(colortex5, coord).x;
}

vec3 celshade(vec3 clrr) {

	//edge detect
	float dtresh = 1.0/(far-near) / (5000.0*Celradius);
	vec4 dc = vec4(edepth(uv.xy));
	vec3 border = vec3(1.0/viewWidth, 1.0/viewHeight, 0.0)*OutlineSize;
	vec4 sa = vec4(edepth(uv.xy + vec2(-border.x,-border.y)),
		 		   edepth(uv.xy + vec2(border.x,-border.y)),
		 		   edepth(uv.xy + vec2(-border.x,border.z)),
		 		   edepth(uv.xy + vec2(border.z,border.y)));

	//opviewSpaceite side samples
	vec4 sb = vec4(edepth(uv.xy + vec2(border.x,border.y)),
		 		   edepth(uv.xy + vec2(-border.x,border.y)),
		 		   edepth(uv.xy + vec2(border.x,border.z)),
		 		   edepth(uv.xy + vec2(border.z,-border.y)));

	vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
		 dd = step(dd.xyzw, vec4(0.0));

	float e = clamp(dot(dd,vec4(0.25f)),0.0,1.0);
	return clrr*e;
}

float luminance(vec3 color) {
    return dot(color, vec3(0.299, 0.587, 0.114));
}

float halftone(float radius, float spacing) {
    vec2 view = uv * vec2(viewWidth, viewHeight);

    float size = radius * 2 + spacing / 2;

    vec2 pos = mod(view, size);
    vec2 center = vec2(size * 0.5);
    float dist = length(pos - center);
    float halftoning = step(radius, dist);
    
    halftoning = 1.0 - halftoning;

    return halftoning;
}

void main() {
    vec3 color = texture2D(colortex0, uv).rgb;
    vec3 noise = texture2D(colortex2, uv).rgb;

    float ht = 1.0 - halftone(DotSize, DotSize * 2);
    
    vec3 qrcolor = round(color * 16.0) / 16.0;
    vec3 qfcolor = floor(color * 16.0) / 16.0;

    float lum = luminance(color);
    float qlum = luminance(qfcolor);

    vec3 qcol1 = qfcolor;
    vec3 qcol2;

    if (lum - qlum > 0.03) qcol2 = qrcolor;
    else qcol2 = qfcolor;
    
    color = qcol1 * ht + qcol2 * (1.0 - ht);
    // color = pow(color, vec3(2.2));
    
    // Color Correction
    float desat = luminance(color);

    float contrast = 1.1;
    float brightness = 0.0;
    float saturation = 0.7;
    float gamma = 1.0;
    vec3 colorFilter = vec3(241, 233, 209) / vec3(255);

    color = contrast * (color - 0.5) + 0.5 + brightness;
    color = clamp(color, 0.0, 1.0);    

    color = mix(vec3(desat), color, saturation);
    color = clamp(color, 0.0, 1.0);

    color *= colorFilter;

    color = pow(color, vec3(gamma));
    // color += noise * 0.07;
    
    #ifdef Celshade
        float depth = texture2D(depthtex0, uv).r;
        depth = (1 - far/near) * depth + (far / near);
        depth = 1.0 / depth;

        // vec3 celshaded = celshade(color);
        // color = mix(celshaded, color, clamp(depth, 0, 1));
        color = celshade(color);
    #endif
    // color = vec3(1.0 - depth);

    

    gl_FragColor = vec4(color, 1.0);
}
