#version 120

varying vec2 uv;

uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float centerDepthSmooth;
const float centerDepthHalflife = 1.0;

// Depth of field is adapted from Sildur's shaders
const float focal = 0.024;
const float aperture = 0.008;	
const float size = 90;

#define ChromaticAbberation 0 // [0 1 2 3]
#define Intensity 7.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0 8.5 9.0 9.5 10.0 10.5 11.0 11.5 12.0 12.5 13.0 13.5 14.0 14.5 15.0 15.5 16.0 16.5 17.0 17.5 18.0 18.5 19.0 19.5 20.0]

uniform vec2 red_offset = vec2(-1) * -1;
uniform vec2 green_offset = vec2(-1) * -1;
uniform vec2 blue_offset = vec2(-1) * -1;

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;

float linearizeDepth(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

/* DRAWBUFFERS:0 */

void main() {
    vec3 color = texture2D(colortex0, uv).rgb;

    if (ChromaticAbberation != 3) {
        vec2 view = vec2(viewWidth, viewHeight);
        vec2 coords = uv * view;
        color = vec3(0.0, 0.0, 0.0);

        vec2 strength;

        switch (ChromaticAbberation) {
        case 0:
            strength = vec2(abs(coords.x - viewWidth/2), abs(coords.y - viewHeight/2));
            strength /= view;
            strength *= Intensity * 2;
            break;
        case 1:
            strength = vec2(Intensity);
            break;
        case 2:
            float pixelWidth = 1.0 / viewWidth;
            float depth = linearizeDepth(texture2D(depthtex0, uv).r) * far;
            float focus = linearizeDepth(centerDepthSmooth) * far;
            float coc = min(abs(aperture * (focal * (depth - focus)) / (depth* (focus - focal))) * size, pixelWidth * 15.0);
            float max_coc = pixelWidth * 15.0;

            strength = vec2(coc / max_coc) * Intensity * 2;
            break;
        }
    
        color.r = texture2D(colortex0, (coords + red_offset * strength) / view).r;
        color.g = texture2D(colortex0, (coords + green_offset * strength) / view).g;
        color.b = texture2D(colortex0, (coords + blue_offset * strength) / view).b;
    }

    gl_FragData[0] = vec4(color, 1.0);
}