/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.item.FileListItem;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AbstractFileListPanel<P extends FileListPanelProxy>
extends TRefreshablePanelElement {
    protected final P proxy;

    public AbstractFileListPanel(int x, int y, int width, int height, P proxy) {
        super(x, y, width, height);
        this.scrollFlags = 4;
        this.scrollPadding = 5;
        this.backgroundColor = -13816531;
        this.outlineColor = 0;
        this.proxy = (FileListPanelProxy)Objects.requireNonNull(proxy);
    }

    public final P getProxy() {
        return this.proxy;
    }

    protected final int nextVerticalItemW() {
        return this.getWidth() - this.getScrollPadding() * 2;
    }

    protected final int nextVerticalItemX() {
        return this.getX() + this.getScrollPadding();
    }

    protected final int nextVerticalItemY() {
        TElement b = (TElement)this.getChildren().getTopmostElements().Item2;
        if (b != null) {
            return b.getEndY() + 3;
        }
        return this.getY() + this.getScrollPadding();
    }

    @Virtual
    protected TLabelElement addSectionLabel(class_2561 text) {
        TLabelElement lbl = new TLabelElement(this.nextVerticalItemX(), this.nextVerticalItemY(), this.nextVerticalItemW(), 15, text);
        this.addChild(lbl, false);
        return lbl;
    }

    @Virtual
    protected FileListItem addFileListItem(@Nullable File file) {
        FileListItem item = new FileListItem(this.nextVerticalItemX(), this.nextVerticalItemY(), this.nextVerticalItemW(), file);
        if (file != null) {
            item.setOnClick(__ -> this.proxy.onPathSelected(file.toPath()));
        }
        this.addChild(item, false);
        return item;
    }

    public static interface FileListPanelProxy {
        public Path getCurrentPath();

        public TFileFilter getCurrentFileFilter();

        public void onPathSelected(Path var1);
    }
}

