/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.layout;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TBlankElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import org.apache.http.annotation.Experimental;

public abstract class UILayout {
    protected int defaultPsp = 0;

    public final int getDefaultPSP() {
        return this.defaultPsp;
    }

    public final void setDefaultPSP(int defaultPsp) {
        this.defaultPsp = Math.abs(defaultPsp);
    }

    @Virtual
    protected int getElementScrollPadding(TParentElement parent) {
        if (parent instanceof TPanelElement) {
            TPanelElement parentPanel = (TPanelElement)parent;
            return parentPanel.getScrollPadding();
        }
        return this.defaultPsp;
    }

    public abstract void apply(TParentElement var1);

    public static final int nextChildBottomY(TParentElement parent) throws NullPointerException {
        return UILayout.nextChildBottomY(parent, 0);
    }

    public static final int nextChildBottomY(TParentElement parent, int defaultScrollPadding) throws NullPointerException {
        TElement bottom;
        Objects.requireNonNull(parent);
        if (parent instanceof TPanelElement) {
            TPanelElement parentPanel = (TPanelElement)parent;
            defaultScrollPadding = parentPanel.getScrollPadding();
        }
        if ((bottom = (TElement)parent.getChildren().getTopmostElements().Item2) != null && bottom.getEndY() <= parent.getY() + defaultScrollPadding) {
            bottom = null;
        }
        return bottom != null ? bottom.getEndY() : parent.getY() + defaultScrollPadding;
    }

    public static final Rectangle nextChildVerticalRect(TParentElement parent) throws NullPointerException {
        return UILayout.nextChildVerticalRect(parent, 0);
    }

    public static final Rectangle nextChildVerticalRect(TParentElement parent, int defaultScrollPadding) throws NullPointerException {
        Objects.requireNonNull(parent);
        if (parent instanceof TPanelElement) {
            TPanelElement parentPanel = (TPanelElement)parent;
            defaultScrollPadding = parentPanel.getScrollPadding();
        }
        int nextY = UILayout.nextChildBottomY(parent, defaultScrollPadding);
        int nextW = parent.getWidth() - defaultScrollPadding * 2;
        int nextX = parent.getX() + defaultScrollPadding;
        return new Rectangle(nextX, nextY, nextW, 20);
    }

    @Experimental
    public static final void initLines(TPanelElement panel, final int color, class_2561 ... texts) {
        class_327 tr = panel.getTextRenderer();
        Objects.requireNonNull(tr);
        final int fh = 9;
        final class_5489 mt = class_5489.method_30892((class_327)tr, (class_2561[])texts);
        Rectangle n1 = UILayout.nextChildVerticalRect(panel);
        TBlankElement el = new TBlankElement(n1.x, n1.y, mt.method_44048() + 10, mt.method_30887() * fh + 4){

            @Override
            public final void render(TDrawContext pencil) {
                mt.method_30896((class_332)pencil, this.getX(), this.getY(), fh + 2, color);
            }
        };
        panel.addChild(el, false);
    }

    public static final void initWrappedLines(TPanelElement panel, class_2561 textToWrap, final int color) {
        final class_327 tr = panel.getTextRenderer();
        Objects.requireNonNull(tr);
        int fh = 9;
        List lines = tr.method_1728((class_5348)textToWrap, panel.getWidth() - panel.getScrollPadding() * 2);
        for (final class_5481 line : lines) {
            Rectangle n1 = UILayout.nextChildVerticalRect(panel);
            TBlankElement el = new TBlankElement(n1.x, n1.y, n1.width, fh + 2){

                @Override
                public final void render(TDrawContext pencil) {
                    pencil.method_51430(tr, line, this.getX(), this.getY(), color, true);
                }
            };
            panel.addChild(el, false);
        }
    }
}

