/*
 * Decompiled with CFR 0.152.
 */
package io.tythee.mixin;

import io.tythee.CpuTimeCollector;
import io.tythee.ReflexClient;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Unique
    private final CpuTimeCollector cpuTimeCollect = new CpuTimeCollector();

    @Inject(method={"render"}, at={@At(value="HEAD", shift=At.Shift.AFTER)})
    private void afterRender(boolean bl, CallbackInfo ci) {
        ReflexClient.getScheduler().Wait();
        this.cpuTimeCollect.startCollect();
        ReflexClient.getScheduler().renderQueueAdd();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;swapBuffers(Lnet/minecraft/client/util/tracy/TracyFrameCapturer;)V")})
    private void beforeFlush(CallbackInfo ci) {
        ReflexClient.getScheduler().renderQueueEndInsert();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;swapBuffers(Lnet/minecraft/client/util/tracy/TracyFrameCapturer;)V", shift=At.Shift.AFTER)})
    private void afterFlush(CallbackInfo ci) {
        Long cpuTime = null;
        if (!ReflexClient.getScheduler().gpuTimeCollectorDeque.isEmpty()) {
            ReflexClient.getScheduler().gpuTimeCollectorDeque.getFirst().startQueryCheck();
        }
        if (!ReflexClient.getScheduler().gpuTimeCollectorDeque.isEmpty() && ReflexClient.getScheduler().gpuTimeCollectorDeque.getFirst().startTimeSystem != null) {
            if (this.cpuTimeCollect.startTime != null) {
                cpuTime = ReflexClient.getScheduler().gpuTimeCollectorDeque.getFirst().startTimeSystem - this.cpuTimeCollect.startTime;
            }
        } else {
            this.cpuTimeCollect.endCollect();
            cpuTime = this.cpuTimeCollect.getCpuTime();
        }
        this.cpuTimeCollect.reset();
        if (cpuTime != null) {
            ReflexClient.getScheduler().updateCpuTime(cpuTime);
        }
    }
}

