/*
 * Decompiled with CFR 0.152.
 */
package io.tythee;

import io.tythee.GpuTimeCollector;
import io.tythee.ObjectPool;
import io.tythee.RenderQueueAction;
import io.tythee.config.ModConfig;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.lwjgl.glfw.GLFW;

public class ReflexScheduler {
    private final float alpha = 0.85f;
    private Long estimateCpuTime = null;
    private final int gpuWindowSize = 60;
    private final long[] gpuTimeRingBuffer = new long[60];
    private int ringBufferIndex = 0;
    private int validSamples = 0;
    public Deque<GpuTimeCollector> gpuTimeCollectorDeque = new ArrayDeque<GpuTimeCollector>();
    ObjectPool.ObjectFactory<GpuTimeCollector> collectorFactory = () -> new GpuTimeCollector();
    ObjectPool.ObjectResetter<GpuTimeCollector> collectorResetter = collector -> collector.reset();
    private final ObjectPool<GpuTimeCollector> collectorPool = new ObjectPool<GpuTimeCollector>(this.collectorFactory, this.collectorResetter);
    private final float weightBase = 1.5f;
    private final float[] gpuWeights = new float[60];
    private static final double NS_TO_SECONDS = 1.0E-9;
    private GpuTimeCollector currentOperateGpuTimeCollector = null;
    private RenderQueueAction lastRenderQueueAction = null;

    public ReflexScheduler() {
        int i;
        float weightSum = 0.0f;
        for (i = 0; i < 60; ++i) {
            this.gpuWeights[i] = (float)Math.pow(1.5, 59 - i);
            weightSum += this.gpuWeights[i];
        }
        i = 0;
        while (i < 60) {
            int n = i++;
            this.gpuWeights[n] = this.gpuWeights[n] / weightSum;
        }
    }

    public void updateCpuTime(long cpuTimeNs) {
        this.estimateCpuTime = this.estimateCpuTime == null ? Long.valueOf(cpuTimeNs) : Long.valueOf((long)(0.85f * (float)cpuTimeNs + 0.14999998f * (float)this.estimateCpuTime.longValue()));
    }

    public void updateGpuTime(long gpuTimeNs) {
        this.gpuTimeRingBuffer[this.ringBufferIndex] = gpuTimeNs;
        this.ringBufferIndex = (this.ringBufferIndex + 1) % 60;
        this.validSamples = Math.min(this.validSamples + 1, 60);
    }

    public Long getEstimateGpuTime() {
        if (this.validSamples == 0) {
            return null;
        }
        float weightedSum = 0.0f;
        for (int i = 0; i < this.validSamples; ++i) {
            int idx = (this.ringBufferIndex - 1 - i + 60) % 60;
            weightedSum += (float)this.gpuTimeRingBuffer[idx] * this.gpuWeights[i];
        }
        return (long)weightedSum;
    }

    private Long calculateWaitTime() {
        Iterator<GpuTimeCollector> gpuTimeCollectorIterator = this.gpuTimeCollectorDeque.iterator();
        while (gpuTimeCollectorIterator.hasNext()) {
            GpuTimeCollector gpuTimeCollector = gpuTimeCollectorIterator.next();
            if (gpuTimeCollector.startQueryInserted && gpuTimeCollector.endQueryInserted) {
                gpuTimeCollector.startQueryCheck();
                if (!gpuTimeCollector.endQueryCheck()) continue;
                gpuTimeCollectorIterator.remove();
                continue;
            }
            gpuTimeCollectorIterator.remove();
        }
        if (this.gpuTimeCollectorDeque.isEmpty()) {
            return null;
        }
        if (this.getEstimateGpuTime() == null || this.estimateCpuTime == null) {
            return null;
        }
        long waitTime = this.gpuTimeCollectorDeque.getLast().startTimeSystem == null ? this.getEstimateGpuTime() * (long)this.gpuTimeCollectorDeque.size() - this.estimateCpuTime : this.gpuTimeCollectorDeque.getLast().startTimeSystem + this.getEstimateGpuTime() * (long)this.gpuTimeCollectorDeque.size() - this.estimateCpuTime - System.nanoTime();
        if ((waitTime -= ModConfig.INSTANCE.getReduceWaitTime()) > 0L) {
            return waitTime;
        }
        return null;
    }

    public void Wait() {
        Long waitTime;
        while ((waitTime = this.calculateWaitTime()) != null && ModConfig.INSTANCE.isReflexEnabled()) {
            GLFW.glfwWaitEventsTimeout((double)((double)waitTime.longValue() * 1.0E-9));
        }
    }

    public void renderQueueAdd() {
        if (this.lastRenderQueueAction != RenderQueueAction.END_INSERT && this.lastRenderQueueAction != null) {
            this.gpuTimeCollectorDeque.remove(this.currentOperateGpuTimeCollector);
            this.collectorPool.returnObject(this.currentOperateGpuTimeCollector);
            this.currentOperateGpuTimeCollector = null;
            this.lastRenderQueueAction = null;
        }
        GpuTimeCollector gpuTimeCollector = this.collectorPool.borrow();
        gpuTimeCollector.setCallback(null, () -> {
            this.updateGpuTime(gpuTimeCollector.endTimeSystem - gpuTimeCollector.startTimeSystem);
            this.collectorPool.returnObject(gpuTimeCollector);
        });
        gpuTimeCollector.startQueryInsert();
        this.gpuTimeCollectorDeque.addFirst(gpuTimeCollector);
        this.currentOperateGpuTimeCollector = gpuTimeCollector;
        this.lastRenderQueueAction = RenderQueueAction.ADD;
    }

    public void renderQueueEndInsert() {
        if (this.lastRenderQueueAction != RenderQueueAction.ADD) {
            this.gpuTimeCollectorDeque.remove(this.currentOperateGpuTimeCollector);
            this.collectorPool.returnObject(this.currentOperateGpuTimeCollector);
            this.currentOperateGpuTimeCollector = null;
            this.lastRenderQueueAction = null;
            return;
        }
        this.currentOperateGpuTimeCollector.endQueryInsert();
        this.lastRenderQueueAction = RenderQueueAction.END_INSERT;
    }
}

