/*
 * Decompiled with CFR 0.152.
 */
package io.tythee;

import io.tythee.ReflexClient;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;

public class GpuTimeCollector {
    public Long startTimeSystem = null;
    public Long endTimeSystem = null;
    public Long startTimeGpu = null;
    public Long endTimeGpu = null;
    public Integer startTimeQuery = null;
    public Integer endTimeQuery = null;
    private Runnable startCallback = null;
    private Runnable endCallback = null;
    public boolean startQueryInserted = false;
    public boolean endQueryInserted = false;

    long gpuToSystem(long gpu) {
        long[] t = new long[1];
        GL33C.glGetInteger64v((int)36392, (long[])t);
        long system = System.nanoTime();
        long gpuToSystemOffset = system - t[0];
        return gpu + gpuToSystemOffset;
    }

    GpuTimeCollector() {
    }

    public void setCallback(Runnable startCallback, Runnable endCallback) {
        this.startCallback = startCallback;
        this.endCallback = endCallback;
    }

    public void startQueryInsert() {
        this.startTimeQuery = GL32C.glGenQueries();
        GL33C.glQueryCounter((int)this.startTimeQuery, (int)36392);
        this.startQueryInserted = true;
        if (this.startTimeQuery == null) {
            throw new RuntimeException("Could not find query insertion time");
        }
    }

    public void startQueryCheck() {
        if (!this.startQueryInserted) {
            ReflexClient.LOGGER.error("startQueryInsert() must be called before startQueryCheck()", (Throwable)new IllegalStateException("startQueryInsert() must be called before startQueryCheck()"));
            throw new IllegalStateException("startQueryInsert() must be called before startQueryCheck()");
        }
        if (this.startTimeGpu == null && GL33C.glGetQueryObjecti64((int)this.startTimeQuery, (int)34919) == 1L) {
            this.startTimeGpu = GL33C.glGetQueryObjecti64((int)this.startTimeQuery, (int)34918);
            GL32C.glDeleteQueries((int)this.startTimeQuery);
            this.startTimeQuery = null;
            this.startTimeSystem = this.gpuToSystem(this.startTimeGpu);
            if (this.startCallback != null) {
                this.startCallback.run();
            }
        }
    }

    public void endQueryInsert() {
        if (!this.startQueryInserted) {
            ReflexClient.LOGGER.error("startQueryInsert() must be called before endQueryInsert()", (Throwable)new IllegalStateException("startQueryInsert() must be called before endQueryInsert()"));
            throw new IllegalStateException("startQueryInsert() must be called before endQueryInsert()");
        }
        this.endTimeQuery = GL32C.glGenQueries();
        GL33C.glQueryCounter((int)this.endTimeQuery, (int)36392);
        this.endQueryInserted = true;
    }

    public boolean endQueryCheck() {
        if (!this.endQueryInserted) {
            ReflexClient.LOGGER.error("endQueryInsert() must be called before endQueryCheck()", (Throwable)new IllegalStateException("endQueryInsert() must be called before endQueryCheck()"));
            throw new IllegalStateException("endQueryInsert() must be called before endQueryCheck()");
        }
        if (GL33C.glGetQueryObjecti64((int)this.endTimeQuery, (int)34919) == 1L) {
            this.endTimeGpu = GL33C.glGetQueryObjecti64((int)this.endTimeQuery, (int)34918);
            GL32C.glDeleteQueries((int)this.endTimeQuery);
            this.endTimeQuery = null;
            this.startQueryCheck();
            if (this.startTimeGpu == null) {
                ReflexClient.LOGGER.error("startTimeGpu is null", (Throwable)new IllegalStateException("startTimeGpu is null"));
                throw new IllegalStateException("startTimeGpu is null");
            }
            this.endTimeSystem = this.gpuToSystem(this.endTimeGpu);
            if (this.endCallback != null) {
                this.endCallback.run();
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.startTimeSystem = null;
        this.endTimeSystem = null;
        this.startTimeGpu = null;
        this.endTimeGpu = null;
        this.startTimeQuery = null;
        this.endTimeQuery = null;
        this.startQueryInserted = false;
        this.endQueryInserted = false;
    }
}

