/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.ShaderLoader;
import mc.euphoria_patches.shadow.com.google.gson.JsonArray;
import mc.euphoria_patches.shadow.com.google.gson.JsonElement;
import mc.euphoria_patches.shadow.com.google.gson.JsonObject;
import mc.euphoria_patches.shadow.com.google.gson.JsonParser;

public class UpdateChecker {
    private static final String UPDATE_URL = "https://api.github.com/repos/EuphoriaPatches/PatcherUpdateChecker/releases";
    private static final String MOD_VERSION = "_1.6.3".replace("_", "");
    public static String NEW_MOD_VERSION = null;
    public static boolean NEW_VERSION_AVAILABLE = false;
    private static boolean UPDATE_CHECK_PERFORMED = false;

    public static boolean isUpdateAvailable() {
        try {
            return NEW_VERSION_AVAILABLE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkForUpdates() {
        if (UPDATE_CHECK_PERFORMED) {
            return;
        }
        UPDATE_CHECK_PERFORMED = true;
        try {
            NEW_MOD_VERSION = UpdateChecker.fetchLatestVersion();
            if (NEW_MOD_VERSION == null) {
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Failed to fetch the latest version.");
                return;
            }
            if (UpdateChecker.isNewerVersion(NEW_MOD_VERSION)) {
                NEW_VERSION_AVAILABLE = true;
                boolean isIris = ShaderLoader.getShaderLoader().equals("iris");
                EuphoriaPatcher.log(isIris ? 0 : 2, "[UPDATE CHECKER] A new version of the EuphoriaPatcher Mod is available: " + NEW_MOD_VERSION);
                EuphoriaPatcher.log(isIris ? 0 : 2, "[UPDATE CHECKER] Download it from Modrinth: https://euphoriapatches.com/download");
                EuphoriaPatcher.log(isIris ? 0 : 1, 0, "[UPDATE CHECKER] Current Version: " + MOD_VERSION);
            } else {
                EuphoriaPatcher.log(0, "[UPDATE CHECKER] The EuphoriaPatcher Mod is up to date");
            }
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Update check failed: " + e.getMessage());
        }
    }

    private static String fetchLatestVersion() throws Exception {
        URL url = new URL(UPDATE_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        if (connection.getResponseCode() != 200) {
            EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Connection timed out.");
            return null;
        }
        try {
            Object object;
            JsonObject latestRelease;
            BufferedReader reader;
            block12: {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    JsonElement jsonElement = new JsonParser().parse(reader);
                    JsonArray releases = jsonElement.getAsJsonArray();
                    latestRelease = null;
                    for (JsonElement releaseElement : releases) {
                        JsonObject release = releaseElement.getAsJsonObject();
                        if (latestRelease != null && release.get("published_at").getAsString().compareTo(latestRelease.get("published_at").getAsString()) <= 0) continue;
                        latestRelease = release;
                    }
                    if (latestRelease != null) break block12;
                    EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] No releases found.");
                    object = MOD_VERSION;
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
                return object;
            }
            object = latestRelease.get("name").getAsString();
            reader.close();
            return object;
        }
        finally {
            connection.disconnect();
        }
    }

    private static boolean isNewerVersion(String latestVersion) {
        String[] latest = latestVersion.split("\\.");
        String[] current = MOD_VERSION.split("\\.");
        for (int i = 0; i < Math.min(latest.length, current.length); ++i) {
            int currentPart;
            int latestPart = Integer.parseInt(latest[i]);
            if (latestPart == (currentPart = Integer.parseInt(current[i]))) continue;
            return latestPart > currentPart;
        }
        return latest.length > current.length;
    }
}

