/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class ModifyPatchedShaderpacks {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ModifyPatchedShaderpacks] " + message);
    }

    public static void modifyFiles(Path patchedFile, boolean styleUnbound, boolean styleReimagined, String targetPath, String fileExtension, String ... regexAndReplacements) throws IOException {
        ModifyPatchedShaderpacks.debugLog("Starting to modify files in '" + patchedFile.getFileName() + "', target path: " + targetPath);
        if (regexAndReplacements.length % 2 != 0) {
            EuphoriaPatcher.log(2, 0, "Regex and replacement pairs must be provided");
            return;
        }
        ModifyPatchedShaderpacks.processShaderPacks(patchedFile, styleUnbound, styleReimagined, shaderPack -> {
            block10: {
                try {
                    Path resolvedPath = shaderPack.resolve(targetPath);
                    ModifyPatchedShaderpacks.debugLog("Processing in shader pack: " + shaderPack.getFileName());
                    if (fileExtension != null && Files.isDirectory(resolvedPath, new LinkOption[0])) {
                        ModifyPatchedShaderpacks.debugLog("Processing directory: " + resolvedPath + " with extension filter: " + fileExtension);
                        try (DirectoryStream<Path> files = Files.newDirectoryStream(resolvedPath, "*" + fileExtension);){
                            for (Path file : files) {
                                ModifyPatchedShaderpacks.modifyFile(file, regexAndReplacements);
                            }
                            break block10;
                        }
                    }
                    ModifyPatchedShaderpacks.debugLog("Processing single file: " + resolvedPath);
                    ModifyPatchedShaderpacks.modifyFile(resolvedPath, regexAndReplacements);
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(2, 0, "Error processing files in " + shaderPack.getFileName() + ": " + e.getMessage());
                }
            }
        });
        ModifyPatchedShaderpacks.debugLog("Finished modifying files for target path: " + targetPath);
    }

    private static void modifyFile(Path filePath, String ... regexAndReplacements) throws IOException {
        ModifyPatchedShaderpacks.debugLog("Modifying file: " + filePath.getFileName());
        String content = new String(Files.readAllBytes(filePath));
        String modifiedContent = ModifyPatchedShaderpacks.applyReplacements(content, regexAndReplacements);
        Files.write(filePath, modifiedContent.getBytes(), new OpenOption[0]);
        ModifyPatchedShaderpacks.debugLog("Successfully modified file: " + filePath.getFileName());
    }

    private static void processShaderPacks(Path patchedFile, boolean styleUnbound, boolean styleReimagined, Consumer<Path> processor) {
        ModifyPatchedShaderpacks.debugLog("Processing shader packs with styleUnbound=" + styleUnbound + ", styleReimagined=" + styleReimagined);
        List<Path> shaderPacks = ModifyPatchedShaderpacks.getShaderPacks(patchedFile, styleUnbound, styleReimagined);
        ModifyPatchedShaderpacks.debugLog("Found " + shaderPacks.size() + " shader packs to process");
        for (Path shaderPack : shaderPacks) {
            if (Files.exists(shaderPack, new LinkOption[0])) {
                processor.accept(shaderPack);
                continue;
            }
            ModifyPatchedShaderpacks.debugLog("Shader pack not found: " + shaderPack);
        }
    }

    private static String applyReplacements(String content, String ... regexAndReplacements) {
        ModifyPatchedShaderpacks.debugLog("Applying " + regexAndReplacements.length / 2 + " regex replacements");
        String modifiedContent = content;
        for (int i = 0; i < regexAndReplacements.length; i += 2) {
            String regex = regexAndReplacements[i];
            String replacement = regexAndReplacements[i + 1];
            ModifyPatchedShaderpacks.debugLog("Applying regex: '" + regex + "' -> '" + replacement + "'");
            modifiedContent = modifiedContent.replaceAll(regex, replacement);
        }
        return modifiedContent;
    }

    private static List<Path> getShaderPacks(Path patchedFile, boolean styleUnbound, boolean styleReimagined) {
        ModifyPatchedShaderpacks.debugLog("Getting shader packs from: " + patchedFile.getFileName());
        ArrayList<Path> shaderPacks = new ArrayList<Path>();
        shaderPacks.add(patchedFile);
        if (styleUnbound && styleReimagined) {
            Path otherStylePath = patchedFile.getFileName().toString().contains("Reimagined") ? patchedFile.resolveSibling(patchedFile.getFileName().toString().replace("Reimagined", "Unbound")) : patchedFile.resolveSibling(patchedFile.getFileName().toString().replace("Unbound", "Reimagined"));
            ModifyPatchedShaderpacks.debugLog("Looking for other style at: " + otherStylePath.getFileName());
            if (Files.exists(otherStylePath, new LinkOption[0])) {
                ModifyPatchedShaderpacks.debugLog("Found other style shader pack: " + otherStylePath.getFileName());
                shaderPacks.add(otherStylePath);
            } else {
                ModifyPatchedShaderpacks.debugLog("Other style shader pack not found: " + otherStylePath.getFileName());
            }
        }
        return shaderPacks;
    }
}

