/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.util;

import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.event.StarFox64Events;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;

public class StarFoxUtil {
    private static final class_5819 random = class_5819.method_43047();
    private static final class_2960 barrelRollSoundId = DoABarrelRoll.id("do_a_barrel_roll");
    private static final class_3414 barrelRollSound = class_3414.method_47908((class_2960)barrelRollSoundId);
    private static final class_2960 barrelRollTexture1 = DoABarrelRoll.id("textures/gui/barrel_roll_1.png");
    private static final class_2960 barrelRollTexture2 = DoABarrelRoll.id("textures/gui/barrel_roll_2.png");
    private static final double rollTol = 90.0;
    private static double rollTracker = 0.0;
    private static int barrelRollTimer = 0;

    public static void register() {
        StarFox64Events.DOES_A_BARREL_ROLL.register(StarFoxUtil::playBarrelRollSound);
        StarFox64Events.DOES_A_BARREL_ROLL.register(player -> {
            barrelRollTimer = 30;
        });
        RollEvents.LATE_CAMERA_MODIFIERS.register(context -> StarFoxUtil.trackRoll(context.getRotationDelta(), context.getCurrentRotation()), 999999);
    }

    public static void clientTick(class_310 client) {
        if (barrelRollTimer > 0) {
            --barrelRollTimer;
        }
    }

    public static void renderPeppy(class_332 context, float tickDelta, int scaledWidth, int scaledHeight) {
        if (barrelRollTimer > 0) {
            int x = scaledWidth / 2 - 75;
            int y = scaledHeight - 90;
            int texture = barrelRollTimer % 2 == 0 ? 1 : 2;
            context.method_25290(class_1921::method_62277, texture == 1 ? barrelRollTexture1 : barrelRollTexture2, x, y, 0.0f, 0.0f, 160, 160, 160, 160);
        }
    }

    private static void trackRoll(RotationInstant rotationDelta, RotationInstant currentRotation) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && StarFoxUtil.isFoxMcCloud((class_1657)player)) {
            double cRoll = currentRotation.roll();
            double dRoll = rotationDelta.roll();
            if (cRoll < 90.0 && cRoll + dRoll >= 90.0) {
                rollTracker = 1.0;
            } else if (cRoll > -90.0 && cRoll + dRoll <= -90.0) {
                rollTracker = -1.0;
            } else if (rollTracker != 0.0) {
                if (rollTracker * dRoll < 0.0) {
                    rollTracker = 0.0;
                }
                if (rollTracker > 0.0 && cRoll <= -90.0 || rollTracker < 0.0 && cRoll >= 90.0) {
                    StarFox64Events.doesABarrelRoll(player);
                    rollTracker = 0.0;
                }
            }
        } else {
            rollTracker = 0.0;
        }
    }

    public static boolean isFoxMcCloud(class_1657 player) {
        if (!ModConfig.INSTANCE.getEnableEasterEggs()) {
            return false;
        }
        class_1799 chestStack = player.method_6118(class_1304.field_6174);
        String name = chestStack.method_7964().getString();
        return chestStack.method_31574(class_1802.field_8833) && (name.equals("Arwing") || name.equals("Star Fox 64") || name.contains("Do a Barrel Roll"));
    }

    public static void playBarrelRollSound(class_1657 player) {
        player.method_37908().method_43129(player, (class_1297)player, barrelRollSound, class_3419.field_15248, 1.0f, (random.method_43057() - random.method_43057()) * 0.2f + 1.0f);
    }
}

