/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.nbttooltip.parse_engine;

import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import zabi.minecraft.nbttooltip.config.ModConfig;
import zabi.minecraft.nbttooltip.parse_engine.NbtTagParser;

public class JsonParser
implements NbtTagParser {
    @Override
    public void parseTagToList(List<class_2561> list, @Nullable class_2520 tag, boolean split) {
        if (tag == null) {
            list.add((class_2561)class_2561.method_43470((String)"{}"));
        } else {
            list.add((class_2561)class_2561.method_43470((String)"{"));
            this.unwrapTag(list, tag, ModConfig.INSTANCE.compress ? "" : "  ", "", ModConfig.INSTANCE.compress ? "" : "  ");
            list.add((class_2561)class_2561.method_43470((String)"}"));
        }
    }

    private void unwrapTag(List<class_2561> tooltip, class_2520 base, String pad, String tagName, String padIncrement) {
        if (base instanceof class_2487) {
            this.addCompoundToTooltip(tooltip, base, pad, padIncrement);
        } else if (base instanceof class_2483) {
            this.addListToTooltip(tooltip, base, pad, padIncrement);
        } else {
            JsonParser.addValueToTooltip(tooltip, base, tagName, pad, false);
        }
    }

    private void addCompoundToTooltip(List<class_2561> tooltip, class_2520 base, String pad, String padIncrement) {
        class_2487 tag = (class_2487)base;
        Iterator iter = tag.method_10541().iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (tag.method_10580(s) instanceof class_2487) {
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "\"" + s + "\": {")));
                this.unwrapTag(tooltip, tag.method_10580(s), pad + padIncrement, s, padIncrement);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "}" + (iter.hasNext() ? "," : ""))));
                continue;
            }
            if (tag.method_10580(s) instanceof class_2483) {
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "\"" + s + "\": [")));
                this.unwrapTag(tooltip, tag.method_10580(s), pad + padIncrement, s, padIncrement);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "]" + (iter.hasNext() ? "," : ""))));
                continue;
            }
            JsonParser.addNamedValueToTooltip(tooltip, tag.method_10580(s), s, pad, iter.hasNext());
        }
    }

    private void addListToTooltip(List<class_2561> tooltip, class_2520 base, String pad, String padIncrement) {
        class_2483 tag = (class_2483)base;
        Iterator iter = tag.iterator();
        while (iter.hasNext()) {
            class_2520 nbtnext = (class_2520)iter.next();
            if (nbtnext instanceof class_2487) {
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "{")));
                this.unwrapTag(tooltip, nbtnext, pad + padIncrement, "", padIncrement);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "}" + (iter.hasNext() ? "," : ""))));
                continue;
            }
            if (nbtnext instanceof class_2483) {
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "[")));
                this.unwrapTag(tooltip, nbtnext, pad + padIncrement, "", padIncrement);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "]" + (iter.hasNext() ? "," : ""))));
                continue;
            }
            JsonParser.addValueToTooltip(tooltip, nbtnext, "", pad, iter.hasNext());
        }
    }

    private static void addNamedValueToTooltip(List<class_2561> tooltip, class_2520 nbt, String name, String pad, boolean addComma) {
        String cleanString = nbt instanceof class_2519 ? JsonParser.escapeChars(nbt.toString()) : JsonParser.stripTypeIdentifiers(nbt.toString());
        tooltip.add((class_2561)class_2561.method_43470((String)(pad + "\"" + name + "\": " + cleanString + (addComma ? "," : ""))));
    }

    private static void addValueToTooltip(List<class_2561> tooltip, class_2520 nbt, String name, String pad, boolean addComma) {
        String cleanString = nbt instanceof class_2519 ? JsonParser.escapeChars(nbt.toString()) : JsonParser.stripTypeIdentifiers(nbt.toString());
        tooltip.add((class_2561)class_2561.method_43470((String)(pad + cleanString + (addComma ? "," : ""))));
    }

    private static String stripTypeIdentifiers(String string) {
        char last = string.charAt(string.length() - 1);
        if (last >= '0' && last <= '9') {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    private static String escapeChars(String in) {
        if (in.charAt(0) == '\"' && in.charAt(in.length() - 1) == '\"' || in.charAt(0) == '\'' && in.charAt(in.length() - 1) == '\'') {
            in = in.substring(1, in.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\"') {
                sb.append('\\');
                sb.append('\"');
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }
}

