/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.nbttooltip.parse_engine;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import zabi.minecraft.nbttooltip.config.ModConfig;
import zabi.minecraft.nbttooltip.parse_engine.NbtTagParser;

public class ColoredHumanReadableParser
implements NbtTagParser {
    private static final int line_split_threshold = 30;
    private static final class_124 LISTINDEX = class_124.field_1060;
    private static final class_124 STRING = class_124.field_1076;
    private static final class_124 STRUCTURE = class_124.field_1080;
    private static final class_124 TAGNAME = class_124.field_1065;

    @Override
    public void parseTagToList(List<class_2561> list, @Nullable class_2520 tag, boolean split) {
        if (tag == null) {
            list.add((class_2561)class_2561.method_43470((String)"No NBT tag").method_27692(class_124.field_1063));
        } else {
            this.unwrapTag(list, tag, "", "", ModConfig.INSTANCE.compress ? "" : "  ", split);
        }
    }

    private void unwrapTag(List<class_2561> tooltip, class_2520 base, String pad, String tagName, String padIncrement, boolean splitLongStrings) {
        if (base instanceof class_2487) {
            this.addCompoundToTooltip(tooltip, base, pad, padIncrement, splitLongStrings);
        } else if (base instanceof class_2483) {
            this.addListToTooltip(tooltip, base, pad, padIncrement, splitLongStrings);
        } else {
            ColoredHumanReadableParser.addValueToTooltip(tooltip, base, (class_2561)class_2561.method_43470((String)tagName).method_27692(TAGNAME), pad, splitLongStrings);
        }
    }

    private void addCompoundToTooltip(List<class_2561> tooltip, class_2520 base, String pad, String padIncrement, boolean splitLongStrings) {
        class_2487 tag = (class_2487)base;
        tag.method_10541().forEach(s -> {
            boolean nested;
            boolean bl = nested = tag.method_10580(s) instanceof class_2483 || tag.method_10580(s) instanceof class_2487;
            if (nested) {
                class_5250 subtreeName = class_2561.method_43470((String)s).method_27692(TAGNAME);
                class_5250 intro = class_2561.method_43469((String)"%s%s%s", (Object[])new Object[]{pad, subtreeName, class_2561.method_43470((String)": {").method_27692(STRUCTURE)});
                tooltip.add((class_2561)intro);
                this.unwrapTag(tooltip, tag.method_10580(s), pad + padIncrement, (String)s, padIncrement, splitLongStrings);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "}")).method_27692(STRUCTURE));
            } else {
                ColoredHumanReadableParser.addValueToTooltip(tooltip, tag.method_10580(s), (class_2561)class_2561.method_43470((String)s).method_27692(TAGNAME), pad, splitLongStrings);
            }
        });
    }

    private void addListToTooltip(List<class_2561> tooltip, class_2520 base, String pad, String padIncrement, boolean splitLongStrings) {
        class_2483 tag = (class_2483)base;
        int index = 0;
        for (class_2520 nbtnext : tag) {
            if (nbtnext instanceof class_2483 || nbtnext instanceof class_2487) {
                tooltip.add((class_2561)class_2561.method_43469((String)"%s [%s]: {", (Object[])new Object[]{pad, class_2561.method_43470((String)("" + index)).method_27692(LISTINDEX)}).method_27692(STRUCTURE));
                this.unwrapTag(tooltip, nbtnext, pad + padIncrement, "", padIncrement, splitLongStrings);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "}")).method_27692(STRUCTURE));
            } else {
                ColoredHumanReadableParser.addValueToTooltip(tooltip, nbtnext, (class_2561)class_2561.method_43469((String)"[%s]", (Object[])new Object[]{class_2561.method_43470((String)("" + index)).method_27692(LISTINDEX)}).method_27692(STRUCTURE), pad, splitLongStrings);
            }
            ++index;
        }
    }

    private static void addValueToTooltip(List<class_2561> tooltip, class_2520 nbt, class_2561 name, String pad, boolean splitLongStrings) {
        String toBeAdded = nbt.toString();
        if (!splitLongStrings || toBeAdded.length() < 30) {
            tooltip.add((class_2561)class_2561.method_43469((String)(pad + "%s: %s"), (Object[])new Object[]{name, class_2561.method_43470((String)nbt.toString()).method_27692(STRING)}));
        } else {
            int nextChunk;
            class_5250 separator = class_2561.method_43470((String)"|").method_27692(class_124.field_1075);
            tooltip.add((class_2561)class_2561.method_43469((String)(pad + "%s:"), (Object[])new Object[]{name}));
            for (int added = 0; added < toBeAdded.length(); added += nextChunk) {
                nextChunk = Math.min(30, toBeAdded.length() - added);
                class_5250 chunk = class_2561.method_43470((String)toBeAdded.substring(added, added + nextChunk)).method_27692(STRING);
                tooltip.add((class_2561)class_2561.method_43469((String)("%s" + pad + "   %s"), (Object[])new Object[]{separator, chunk}));
            }
        }
    }
}

