/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.nbttooltip.parse_engine;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import zabi.minecraft.nbttooltip.NBTTooltip;
import zabi.minecraft.nbttooltip.config.ModConfig;
import zabi.minecraft.nbttooltip.parse_engine.NbtTagParser;

public class BWHumanReadableParser
implements NbtTagParser {
    private static final int line_split_threshold = 30;

    @Override
    public void parseTagToList(List<class_2561> list, @Nullable class_2520 tag, boolean split) {
        if (tag == null) {
            list.add((class_2561)class_2561.method_43470((String)"No NBT tag"));
        } else {
            this.unwrapTag(list, tag, NBTTooltip.FORMAT, "", ModConfig.INSTANCE.compress ? "" : "  ", split);
        }
    }

    private void unwrapTag(List<class_2561> tooltip, class_2520 base, String pad, String tagName, String padIncrement, boolean splitLongStrings) {
        if (base instanceof class_2487) {
            this.addCompoundToTooltip(tooltip, base, pad, padIncrement, splitLongStrings);
        } else if (base instanceof class_2483) {
            this.addListToTooltip(tooltip, base, pad, padIncrement, splitLongStrings);
        } else {
            BWHumanReadableParser.addValueToTooltip(tooltip, base, tagName, pad, splitLongStrings);
        }
    }

    private void addCompoundToTooltip(List<class_2561> tooltip, class_2520 base, String pad, String padIncrement, boolean splitLongStrings) {
        class_2487 tag = (class_2487)base;
        tag.method_10541().forEach(s -> {
            boolean nested;
            boolean bl = nested = tag.method_10580(s) instanceof class_2483 || tag.method_10580(s) instanceof class_2487;
            if (nested) {
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + s + ": {")));
                this.unwrapTag(tooltip, tag.method_10580(s), pad + padIncrement, (String)s, padIncrement, splitLongStrings);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "}")));
            } else {
                BWHumanReadableParser.addValueToTooltip(tooltip, tag.method_10580(s), s, pad, splitLongStrings);
            }
        });
    }

    private void addListToTooltip(List<class_2561> tooltip, class_2520 base, String pad, String padIncrement, boolean splitLongStrings) {
        class_2483 tag = (class_2483)base;
        int index = 0;
        for (class_2520 nbtnext : tag) {
            if (nbtnext instanceof class_2483 || nbtnext instanceof class_2487) {
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "[" + index + "]: {")));
                this.unwrapTag(tooltip, nbtnext, pad + padIncrement, "", padIncrement, splitLongStrings);
                tooltip.add((class_2561)class_2561.method_43470((String)(pad + "}")));
            } else {
                BWHumanReadableParser.addValueToTooltip(tooltip, nbtnext, "[" + index + "]", pad, splitLongStrings);
            }
            ++index;
        }
    }

    private static void addValueToTooltip(List<class_2561> tooltip, class_2520 nbt, String name, String pad, boolean splitLongStrings) {
        String toBeAdded = nbt.toString();
        if (!splitLongStrings || toBeAdded.length() < 30) {
            tooltip.add((class_2561)class_2561.method_43470((String)(pad + name + ": " + String.valueOf(nbt))));
        } else {
            int nextChunk;
            tooltip.add((class_2561)class_2561.method_43470((String)(pad + name + ":")));
            for (int added = 0; added < toBeAdded.length(); added += nextChunk) {
                nextChunk = Math.min(30, toBeAdded.length() - added);
                String sb = new StringBuilder().append(class_124.field_1075).append("|").append(class_124.field_1070).append(pad).append("   ").append(toBeAdded, added, added + nextChunk).toString();
                tooltip.add((class_2561)class_2561.method_43470((String)sb));
            }
        }
    }
}

