/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.nbttooltip;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_9326;
import zabi.minecraft.nbttooltip.config.ModConfig;
import zabi.minecraft.nbttooltip.parse_engine.NbtTagParser;

public class NBTTooltip
implements ClientModInitializer {
    public static int ticks = 0;
    public static int line_scrolled = 0;
    public static final String FORMAT = class_124.field_1056.toString() + String.valueOf(class_124.field_1063);
    public static final int WAITTIME_BEFORE_FAST_SCROLL = 10;
    public static class_304 COPY_TO_CLIPBOARD = new class_304("key.nbttooltip.copy", class_3675.class_307.field_1668, 262, "key.category.nbttooltip");
    public static class_304 TOGGLE_NBT = new class_304("key.nbttooltip.toggle", class_3675.class_307.field_1668, 263, "key.category.nbttooltip");
    public static class_304 SCROLL_UP = new class_304("key.nbttooltip.scroll_up", class_3675.class_307.field_1668, 265, "key.category.nbttooltip");
    public static class_304 SCROLL_DOWN = new class_304("key.nbttooltip.scroll_down", class_3675.class_307.field_1668, 264, "key.category.nbttooltip");
    public static boolean flipflop_key_copy = false;
    public static boolean flipflop_key_toggle = false;
    public static boolean nbtKeyToggled = false;
    public static boolean nbtKeyPressed = false;
    public static int fast_scroll_warmup = 0;
    public static int autoscroll_locks = 0;

    public void onInitializeClient() {
        ModConfig.init();
        ClientTickEvents.END_CLIENT_TICK.register(NBTTooltip::clientTick);
        ItemTooltipCallback.EVENT.register(NBTTooltip::onInjectTooltip);
        KeyBindingHelper.registerKeyBinding((class_304)COPY_TO_CLIPBOARD);
        KeyBindingHelper.registerKeyBinding((class_304)TOGGLE_NBT);
        KeyBindingHelper.registerKeyBinding((class_304)SCROLL_DOWN);
        KeyBindingHelper.registerKeyBinding((class_304)SCROLL_UP);
    }

    public static void clientTick(class_310 mc) {
        if (mc.field_1687 == null) {
            return;
        }
        if (autoscroll_locks > 0) {
            --autoscroll_locks;
        }
        if (!(class_437.method_25442() || NBTTooltip.isPressed(mc, SCROLL_DOWN) || NBTTooltip.isPressed(mc, SCROLL_UP) || autoscroll_locks != 0)) {
            ++ticks;
            int factor = 1;
            if (class_437.method_25443()) {
                factor = 4;
            }
            if (ticks >= ModConfig.INSTANCE.ticksBeforeScroll / factor) {
                ticks = 0;
                if (ModConfig.INSTANCE.ticksBeforeScroll > 0) {
                    ++line_scrolled;
                }
            }
        }
        if (NBTTooltip.isPressed(mc, TOGGLE_NBT)) {
            if (!flipflop_key_toggle) {
                nbtKeyToggled = !nbtKeyToggled;
            }
            flipflop_key_toggle = true;
            nbtKeyPressed = true;
        } else {
            flipflop_key_toggle = false;
            nbtKeyPressed = false;
        }
        if (!NBTTooltip.isPressed(mc, SCROLL_DOWN) && NBTTooltip.isPressed(mc, SCROLL_UP) && line_scrolled > 0 && NBTTooltip.cooldownTimeAcceptable()) {
            --line_scrolled;
        }
        if (NBTTooltip.isPressed(mc, SCROLL_DOWN) && !NBTTooltip.isPressed(mc, SCROLL_UP) && NBTTooltip.cooldownTimeAcceptable()) {
            ++line_scrolled;
        }
        if (NBTTooltip.isPressed(mc, SCROLL_DOWN) || NBTTooltip.isPressed(mc, SCROLL_UP)) {
            if (fast_scroll_warmup < 10) {
                ++fast_scroll_warmup;
            }
            autoscroll_locks = 2;
        } else {
            fast_scroll_warmup = 0;
        }
    }

    private static boolean cooldownTimeAcceptable() {
        return fast_scroll_warmup == 0 || fast_scroll_warmup >= 10;
    }

    private static boolean isPressed(class_310 mc, class_304 key) {
        return !key.method_1415() && class_3675.method_15987((long)mc.method_22683().method_4490(), (int)class_3675.method_15981((String)key.method_1428()).method_1444());
    }

    public static ArrayList<class_2561> transformTtip(ArrayList<class_2561> ttip, int lines) {
        ArrayList<class_2561> newttip = new ArrayList<class_2561>(lines);
        if (ModConfig.INSTANCE.showSeparator) {
            newttip.add((class_2561)class_2561.method_43470((String)"- NBTTooltip -"));
        }
        if (ttip.size() > lines) {
            if (lines + line_scrolled > ttip.size()) {
                line_scrolled = NBTTooltip.isPressed(class_310.method_1551(), SCROLL_DOWN) ? ttip.size() - lines : 0;
            }
            for (int i = 0; i < lines; ++i) {
                newttip.add(ttip.get(i + line_scrolled));
            }
        } else {
            line_scrolled = 0;
            newttip.addAll(ttip);
        }
        return newttip;
    }

    public static void onInjectTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 type, List<class_2561> list) {
        NBTTooltip.handleClipboardCopy(stack);
        if (ModConfig.INSTANCE.triggerType.shouldShowTooltip(context, type)) {
            if (autoscroll_locks > 0) {
                autoscroll_locks = 2;
            }
            int lines = ModConfig.INSTANCE.maxLinesShown;
            if (ModConfig.INSTANCE.ctrlSuppressesRest && class_437.method_25441()) {
                lines += list.size();
                list.clear();
            } else {
                list.add((class_2561)class_2561.method_43470((String)""));
            }
            ArrayList<class_2561> ttip = new ArrayList<class_2561>(lines);
            class_2487 tag = NBTTooltip.encodeStack(stack, (DynamicOps<class_2520>)context.method_59527().method_57093((DynamicOps)class_2509.field_11560));
            if (!tag.method_33133()) {
                if (ModConfig.INSTANCE.showDelimiters) {
                    ttip.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1064) + " - nbt start -")));
                }
                if (ModConfig.INSTANCE.compress) {
                    ttip.add((class_2561)class_2561.method_43470((String)(FORMAT + String.valueOf(tag))));
                } else {
                    NBTTooltip.getRenderingEngine().parseTagToList(ttip, (class_2520)tag, ModConfig.INSTANCE.splitLongLines);
                }
                if (ModConfig.INSTANCE.showDelimiters) {
                    ttip.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1064) + " - nbt end -")));
                }
                ttip = NBTTooltip.transformTtip(ttip, lines);
                list.addAll(ttip);
            } else {
                list.add((class_2561)class_2561.method_43470((String)(FORMAT + "No NBT data")));
            }
        }
    }

    private static class_2487 encodeStack(class_1799 stack, DynamicOps<class_2520> ops) {
        DataResult result = class_9326.field_49589.encodeStart(ops, (Object)stack.method_57380());
        result.ifError(e -> {});
        class_2520 nbtElement = (class_2520)result.getOrThrow();
        return (class_2487)nbtElement;
    }

    private static void handleClipboardCopy(class_1799 stack) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null) {
            if (NBTTooltip.isPressed(mc, COPY_TO_CLIPBOARD)) {
                if (!flipflop_key_copy) {
                    flipflop_key_copy = true;
                    NBTTooltip.copyToClipboard(stack, mc);
                }
            } else {
                flipflop_key_copy = false;
            }
        }
    }

    private static void copyToClipboard(class_1799 stack, class_310 mc) {
        StringBuilder sb = new StringBuilder();
        String name = class_1074.method_4662((String)stack.method_7909().method_7876(), (Object[])new Object[0]);
        ArrayList<class_2561> nbtData = new ArrayList<class_2561>();
        NBTTooltip.getCopyingEngine().parseTagToList(nbtData, (class_2520)NBTTooltip.encodeStack(stack, (DynamicOps<class_2520>)mc.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560)), false);
        nbtData.forEach(t -> {
            sb.append(t.getString().replaceAll("\u00a7[0-9a-gk-or]", ""));
            sb.append("\n");
        });
        try {
            mc.field_1774.method_1455(sb.toString());
            mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"nbttooltip.copied_to_clipboard"), (class_2561)class_2561.method_43469((String)"nbttooltip.object_details", (Object[])new Object[]{name})));
        }
        catch (Exception e) {
            mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"nbttooltip.copy_failed"), (class_2561)class_2561.method_43470((String)e.getMessage())));
            e.printStackTrace();
        }
    }

    private static NbtTagParser getRenderingEngine() {
        return ModConfig.INSTANCE.tooltipEngine.getEngine();
    }

    private static NbtTagParser getCopyingEngine() {
        return ModConfig.INSTANCE.copyingEngine.getEngine();
    }
}

