/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.neoforge.internal;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.neoforge.NeoForgeAdapter;
import com.sk89q.worldedit.neoforge.internal.NBTConverter;
import com.sk89q.worldedit.neoforge.internal.NeoForgeEntity;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NeoForgeServerLevelDelegateProxy
implements InvocationHandler,
AutoCloseable {
    private final EditSession editSession;
    private final ServerLevel serverLevel;
    private final Map<BlockVector3, BlockEntity> createdBlockEntities = new HashMap<BlockVector3, BlockEntity>();

    private NeoForgeServerLevelDelegateProxy(EditSession editSession, ServerLevel serverLevel) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
    }

    public static LevelAndProxy newInstance(EditSession editSession, ServerLevel serverLevel) {
        NeoForgeServerLevelDelegateProxy proxy = new NeoForgeServerLevelDelegateProxy(editSession, serverLevel);
        return new LevelAndProxy((WorldGenLevel)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)proxy), proxy);
    }

    @Nullable
    private BlockEntity getBlockEntity(BlockPos blockPos) {
        BlockVector3 pos = NeoForgeAdapter.adapt(blockPos);
        return this.createdBlockEntities.get(pos);
    }

    private BlockState getBlockState(BlockPos blockPos) {
        return NeoForgeAdapter.adapt(this.editSession.getBlockWithBuffer(NeoForgeAdapter.adapt(blockPos)));
    }

    private boolean setBlock(BlockPos blockPos, BlockState blockState) {
        try {
            this.handleBlockEntity(blockPos, blockState);
            return this.editSession.setBlock(NeoForgeAdapter.adapt(blockPos), NeoForgeAdapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleBlockEntity(BlockPos blockPos, BlockState blockState) {
        BlockVector3 pos = NeoForgeAdapter.adapt(blockPos);
        if (blockState.hasBlockEntity()) {
            Block block = blockState.getBlock();
            if (!(block instanceof EntityBlock)) {
                throw new AssertionError((Object)("BlockState has block entity but block is not an EntityBlock: " + String.valueOf(blockState)));
            }
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity newEntity = entityBlock.newBlockEntity(blockPos, blockState);
            if (newEntity != null) {
                newEntity.setBlockState(blockState);
                this.createdBlockEntities.put(pos, newEntity);
                return;
            }
        }
        this.createdBlockEntities.remove(pos);
    }

    private boolean removeBlock(BlockPos blockPos, boolean bl) {
        return this.setBlock(blockPos, Blocks.AIR.defaultBlockState());
    }

    private boolean addEntity(Entity entity) {
        BaseEntity baseEntity;
        Vector3 pos = NeoForgeAdapter.adapt(entity.getPosition(0.0f));
        Location location = new Location((Extent)NeoForgeAdapter.adapt(this.serverLevel), pos.x(), pos.y(), pos.z());
        return this.editSession.createEntity(location, baseEntity = new NeoForgeEntity(entity).getState()) != null;
    }

    @Override
    public void close() throws MaxChangedBlocksException {
        for (Map.Entry<BlockVector3, BlockEntity> entry : this.createdBlockEntities.entrySet()) {
            BlockVector3 blockPos = entry.getKey();
            BlockEntity blockEntity = entry.getValue();
            CompoundTag tag = blockEntity.saveWithId((HolderLookup.Provider)this.serverLevel.registryAccess());
            this.editSession.setBlock(blockPos, NeoForgeAdapter.adapt(blockEntity.getBlockState()).toBaseBlock(LazyReference.from(() -> NBTConverter.fromNative(tag))));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getBlockState": 
            case "m_8055_": {
                Object object;
                if (args.length != 1 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                return this.getBlockState(blockPos);
            }
            case "isStateAtPosition": 
            case "m_7433_": {
                Object object;
                if (args.length != 2 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                if (!(args[1] instanceof Predicate)) break;
                Predicate predicate = (Predicate)args[1];
                return predicate.test(this.getBlockState(blockPos));
            }
            case "getBlockEntity": 
            case "m_7702_": {
                Object predicate;
                if (args.length != 1 || !((predicate = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)predicate;
                return this.getBlockEntity(blockPos);
            }
            case "setBlock": 
            case "m_7731_": {
                Object object;
                if (args.length < 2 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                object = args[1];
                if (!(object instanceof BlockState)) break;
                BlockState blockState = (BlockState)object;
                return this.setBlock(blockPos, blockState);
            }
            case "removeBlock": 
            case "destroyBlock": 
            case "m_7471_": 
            case "m_7740_": {
                Object object;
                if (args.length < 2 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                object = args[1];
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                return this.removeBlock(blockPos, bl);
            }
            case "addEntity": 
            case "m_8872_": 
            case "addFreshEntityWithPassengers": 
            case "m_47205_": {
                Object object;
                if (args.length < 1 || !((object = args[0]) instanceof Entity)) break;
                Entity entity = (Entity)object;
                return this.addEntity(entity);
            }
        }
        return method.invoke((Object)this.serverLevel, args);
    }

    public record LevelAndProxy(WorldGenLevel level, NeoForgeServerLevelDelegateProxy proxy) implements AutoCloseable
    {
        @Override
        public void close() throws MaxChangedBlocksException {
            this.proxy.close();
        }
    }
}

