/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;

public class SoundDefinition<T> {
    private final class_2960 soundEvent;
    private final TagList<T> keys;
    private final Optional<Float> volume;
    private final Optional<Float> pitch;

    protected SoundDefinition(class_2960 soundEvent, TagList<T> keys, Optional<Float> volume, Optional<Float> pitch) {
        this.soundEvent = soundEvent;
        this.keys = keys;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static <T> Codec<SoundDefinition<T>> getCodec(class_5321<? extends class_2378<T>> registryKey) {
        return RecordCodecBuilder.create(builder -> builder.group((App)class_2960.field_25139.fieldOf("soundEvent").forGetter(i -> i.soundEvent), (App)TagList.getCodec(registryKey).fieldOf("keys").forGetter(SoundDefinition::getKeys), (App)class_5699.field_34387.optionalFieldOf("volume").forGetter(SoundDefinition::getVolume), (App)class_5699.field_34387.optionalFieldOf("pitch").forGetter(SoundDefinition::getPitch)).apply((Applicative)builder, SoundDefinition::new));
    }

    public class_2960 getSoundEvent() {
        return this.soundEvent;
    }

    public TagList<T> getKeys() {
        return this.keys;
    }

    public Optional<Float> getPitch() {
        return this.pitch;
    }

    public Optional<Float> getVolume() {
        return this.volume;
    }

    public static class Builder<T> {
        private final class_2960 soundEvent;
        private final TagList<T> keys = new TagList(new ArrayList());
        private final class_2378<T> registry;
        private Optional<Float> volume = Optional.empty();
        private Optional<Float> pitch = Optional.empty();

        public Builder(class_2960 soundEvent, class_2378<T> registry) {
            this.soundEvent = soundEvent;
            this.registry = registry;
        }

        public Builder<T> addKey(T key) {
            this.keys.add(Either.left((Object)((class_5321)this.registry.method_29113(key).orElseThrow(() -> new RuntimeException("SoundDefinition.Builder: Could not find RegistryKey for " + key.toString())))));
            return this;
        }

        @SafeVarargs
        public final Builder<T> addMultipleKeys(T ... keys) {
            for (T key : keys) {
                this.addKey(key);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> addMultipleKeys(class_6862<T> ... keys) {
            for (class_6862<T> key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder<T> addKey(class_6862<T> key) {
            this.keys.add(Either.right(key));
            return this;
        }

        public Builder<T> setVolume(float volume) {
            this.volume = Optional.of(Float.valueOf(volume));
            return this;
        }

        public Builder<T> setPitch(float pitch) {
            this.pitch = Optional.of(Float.valueOf(pitch));
            return this;
        }

        public SoundDefinition<T> build() {
            return new SoundDefinition<T>(this.soundEvent, this.keys, this.volume, this.pitch);
        }
    }
}

