/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatch;
import xland.mcmod.enchlevellangpatch.impl.NamespacedKey;

@API(status=API.Status.INTERNAL)
public final class IndependentLangPatchRegistry {
    private final BiMap<NamespacedKey, EnchantmentLevelLangPatch> map = HashBiMap.create();
    private final NamespacedKey defaultId;
    private EnchantmentLevelLangPatch defaultValue;
    private volatile ImmutableBiMap<String, EnchantmentLevelLangPatch> asImmutableBiMap;
    private boolean isFrozen;
    public static final NamespacedKey LP_DEFAULT = NamespacedKey.of("enchlevel-langpatch:default");

    IndependentLangPatchRegistry(NamespacedKey defaultId) {
        this.defaultId = defaultId;
    }

    @Contract(value=" -> new")
    @NotNull
    static IndependentLangPatchRegistry of() {
        return new IndependentLangPatchRegistry(LP_DEFAULT);
    }

    public synchronized void add(NamespacedKey id, EnchantmentLevelLangPatch e) {
        this.checkFreeze();
        this.map.put((Object)id, (Object)e);
        if (Objects.equals(this.defaultId, id)) {
            this.defaultValue = e;
        }
        this.asImmutableBiMap = null;
    }

    public void add(String id, EnchantmentLevelLangPatch e) {
        this.add(NamespacedKey.of(id), e);
    }

    public synchronized EnchantmentLevelLangPatch get(NamespacedKey id) {
        return (EnchantmentLevelLangPatch)this.map.getOrDefault((Object)id, (Object)this.defaultValue);
    }

    public synchronized NamespacedKey getId(EnchantmentLevelLangPatch e) {
        return (NamespacedKey)this.map.inverse().getOrDefault((Object)e, (Object)this.defaultId);
    }

    public NamespacedKey getDefaultId() {
        return this.defaultId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndependentLangPatchRegistry that = (IndependentLangPatchRegistry)o;
        return Objects.equals(this.map, that.map) && Objects.equals(this.getDefaultId(), that.getDefaultId()) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.defaultId, this.defaultValue);
    }

    public String toString() {
        return "IndependentLangPatchRegistry{map=" + this.map + ", defaultId=" + this.defaultId + '}';
    }

    private void checkFreeze() {
        if (this.isFrozen) {
            throw new IllegalStateException("Registry is locked");
        }
    }

    public synchronized boolean isFrozen() {
        return this.isFrozen;
    }

    public synchronized void freeze() {
        this.isFrozen = true;
    }

    public synchronized void unfreeze() {
        this.isFrozen = false;
    }

    private ImmutableBiMap<String, EnchantmentLevelLangPatch> computeMap() {
        return (ImmutableBiMap)this.map.entrySet().parallelStream().collect(ImmutableBiMap.toImmutableBiMap(e -> ((NamespacedKey)e.getKey()).toString(), Map.Entry::getValue));
    }

    public synchronized ImmutableBiMap<String, EnchantmentLevelLangPatch> asImmutableBiMap() {
        ImmutableBiMap<String, EnchantmentLevelLangPatch> m = this.asImmutableBiMap;
        if (m == null) {
            this.asImmutableBiMap = m = this.computeMap();
        }
        return m;
    }
}

