/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.particle_core;

import com.google.gson.Gson;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001c\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR*\u0010\f\u001a\n \b*\u0004\u0018\u00010\u000b0\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lme/fzzyhmstrs/particle_core/PcDisable;", "", "<init>", "()V", "", "getDisabledMixinsConfig", "()Ljava/lang/String;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Lme/fzzyhmstrs/particle_core/PcDisable$DisabledOptimizations;", "disabledOptimizations", "Lme/fzzyhmstrs/particle_core/PcDisable$DisabledOptimizations;", "getDisabledOptimizations", "()Lme/fzzyhmstrs/particle_core/PcDisable$DisabledOptimizations;", "setDisabledOptimizations", "(Lme/fzzyhmstrs/particle_core/PcDisable$DisabledOptimizations;)V", "DisabledOptimizations", "particle_core"})
public final class PcDisable {
    @NotNull
    public static final PcDisable INSTANCE;
    private static final Gson gson;
    private static DisabledOptimizations disabledOptimizations;

    private PcDisable() {
    }

    /*
     * WARNING - void declaration
     */
    private final String getDisabledMixinsConfig() {
        String string;
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "particle_core_disabled_optimizations.json");
        if (!file.exists()) {
            void var2_2;
            String text = gson.toJson((Object)new DisabledOptimizations());
            Intrinsics.checkNotNull((Object)text);
            FilesKt.writeText$default((File)file, (String)text, null, (int)2, null);
            string = var2_2;
        } else {
            string = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)file, null, (int)1, null), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    public final DisabledOptimizations getDisabledOptimizations() {
        return disabledOptimizations;
    }

    public final void setDisabledOptimizations(DisabledOptimizations disabledOptimizations) {
        PcDisable.disabledOptimizations = disabledOptimizations;
    }

    static {
        DisabledOptimizations disabledOptimizations;
        INSTANCE = new PcDisable();
        gson = new Gson().newBuilder().setPrettyPrinting().setLenient().create();
        try {
            disabledOptimizations = (DisabledOptimizations)gson.fromJson(INSTANCE.getDisabledMixinsConfig(), DisabledOptimizations.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            disabledOptimizations = new DisabledOptimizations();
        }
        PcDisable.disabledOptimizations = disabledOptimizations;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR.\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/fzzyhmstrs/particle_core/PcDisable$DisabledOptimizations;", "", "<init>", "()V", "", "className", "", "shouldDisableMixin", "(Ljava/lang/String;)Z", "", "_Disable_Optimizations_Options", "Ljava/util/Map;", "get_Disable_Optimizations_Options", "()Ljava/util/Map;", "set_Disable_Optimizations_Options", "(Ljava/util/Map;)V", "", "disableOptimizations", "Ljava/util/List;", "getDisableOptimizations", "()Ljava/util/List;", "setDisableOptimizations", "(Ljava/util/List;)V", "particle_core"})
    public static final class DisabledOptimizations {
        @NotNull
        private Map<String, String> _Disable_Optimizations_Options;
        @NotNull
        private List<String> disableOptimizations;

        public DisabledOptimizations() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ROTATION", (Object)"[Impact: Medium] Disables mixins related to vertex rotation caching (ParticleManagerRotationMixin, BillboardParticleMixin)"), TuplesKt.to((Object)"CULLING", (Object)"[Impact: High] Disables mixins related to particle culling (FrustumAccessor, ParticleAccessor, ParticleManagerFrustumMixin, WorldRendererFrustumMixin)"), TuplesKt.to((Object)"TYPE", (Object)"[Impact: Low to Medium] Disables mixins related to particle disabling and reduction (WorldRendererTypeMixin)"), TuplesKt.to((Object)"DECREASE", (Object)"[Impact: Low] Disables mixins related particle settings reduction (ALL, DECREASED, MINIMAL) (WorldRendererDecreaseMixin)"), TuplesKt.to((Object)"LIGHTMAP", (Object)"[Impact: Medium] Disables mixins related to light map caching (ParticleManagerCachedLightMixin, ParticleMixin)"), TuplesKt.to((Object)"POTION", (Object)"[Impact: Low] Disables mixins related to potion particle disabling (LivingEntityMixin)")};
            this._Disable_Optimizations_Options = MapsKt.mapOf((Pair[])pairArray);
            this.disableOptimizations = CollectionsKt.listOf((Object)"NONE");
        }

        @NotNull
        public final Map<String, String> get_Disable_Optimizations_Options() {
            return this._Disable_Optimizations_Options;
        }

        public final void set_Disable_Optimizations_Options(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this._Disable_Optimizations_Options = map;
        }

        @NotNull
        public final List<String> getDisableOptimizations() {
            return this.disableOptimizations;
        }

        public final void setDisableOptimizations(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.disableOptimizations = list;
        }

        public final boolean shouldDisableMixin(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            if (this.disableOptimizations.contains("ROTATION") && (StringsKt.endsWith$default((String)className, (String)"ParticleManagerRotationMixin", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)className, (String)"BillboardParticleMixin", (boolean)false, (int)2, null))) {
                System.out.println((Object)("Disabling [" + className + "] due to 'ROTATION' key in particle core config!"));
                return true;
            }
            if (this.disableOptimizations.contains("CULLING") && (StringsKt.endsWith$default((String)className, (String)"FrustumAccessor", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)className, (String)"ParticleAccessor", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)className, (String)"ParticleManagerFrustumMixin", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)className, (String)"WorldRendererFrustumMixin", (boolean)false, (int)2, null))) {
                System.out.println((Object)("Disabling [" + className + "] due to 'CULLING' key in particle core config!"));
                return true;
            }
            if (this.disableOptimizations.contains("TYPE") && StringsKt.endsWith$default((String)className, (String)"WorldRendererTypeMixin", (boolean)false, (int)2, null)) {
                System.out.println((Object)("Disabling [" + className + "] due to 'TYPE' key in particle core config!"));
                return true;
            }
            if (this.disableOptimizations.contains("DECREASE") && StringsKt.endsWith$default((String)className, (String)"WorldRendererDecreaseMixin", (boolean)false, (int)2, null)) {
                System.out.println((Object)("Disabling [" + className + "] due to 'DECREASE' key in particle core config!"));
                return true;
            }
            if (this.disableOptimizations.contains("LIGHTMAP") && (StringsKt.endsWith$default((String)className, (String)"ParticleManagerCachedLightMixin", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)className, (String)"ParticleMixin", (boolean)false, (int)2, null))) {
                System.out.println((Object)("Disabling [" + className + "] due to 'LIGHTMAP' key in particle core config!"));
                return true;
            }
            if (this.disableOptimizations.contains("POTION") && StringsKt.endsWith$default((String)className, (String)"LivingEntityMixin", (boolean)false, (int)2, null)) {
                System.out.println((Object)("Disabling [" + className + "] due to 'POTION' key in particle core config!"));
                return true;
            }
            return false;
        }
    }
}

