/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.selectors;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.DataComponentManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1792;
import net.minecraft.class_2291;
import net.minecraft.class_2960;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/class_2291$class_9217"})
public abstract class ItemParserStateMixin {
    @Shadow
    @Final
    private StringReader field_48971;
    @Shadow
    @Final
    private class_2291.class_9219 field_48972;
    @Unique
    private int cursorBeforeItem = -1;
    @Unique
    private int cursorBeforeComponent = -1;
    @Unique
    private final Set<class_9331<?>> parsedComponents = new HashSet();
    @Unique
    @Nullable
    private class_9331<?> lastAdded = null;

    @Shadow
    public static class_9331<?> method_57807(StringReader reader) throws CommandSyntaxException {
        return null;
    }

    @Inject(method={"method_56872()V"}, at={@At(value="HEAD")})
    private void atReadItem(CallbackInfo ci) {
        this.cursorBeforeItem = this.field_48971.getCursor();
    }

    @Inject(method={"method_57814()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2291$class_9217;method_57807(Lcom/mojang/brigadier/StringReader;)Lnet/minecraft/class_9331;")})
    private void captureComponentId(CallbackInfo ci) {
        int currentCursor = this.field_48971.getCursor();
        try {
            class_9331<?> componentType = ItemParserStateMixin.method_57807(this.field_48971);
            this.parsedComponents.add(componentType);
            this.lastAdded = componentType;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        this.field_48971.setCursor(currentCursor);
    }

    @Inject(method={"method_57814()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2291$class_9217;method_57811(Lnet/minecraft/class_9331;)V")})
    private void atReadComponents(CallbackInfo ci) {
        this.field_48972.method_56880(this::suggestComponentData);
        this.cursorBeforeComponent = this.field_48971.getCursor();
    }

    @Inject(method={"method_60383(Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")}, cancellable=true)
    private void atSuggestComponentAssignment(SuggestionsBuilder suggestionsBuilder, CallbackInfoReturnable<CompletableFuture<Suggestions>> cir) {
        class_1792 item = this.findParsedItem();
        String str = suggestionsBuilder.getRemaining().toLowerCase();
        SuggestionList suggestionList = new SuggestionList();
        DataComponentManager.loadSuggestions(suggestionList, str, this.parsedComponents, item, null, true);
        if (str.isEmpty() || str.equals("!")) {
            suggestionList.addRaw("!", "(remove component)", 80);
        }
        suggestionList.forEach(s -> s.suggest(suggestionsBuilder));
        cir.setReturnValue((Object)suggestionsBuilder.buildFuture());
        cir.cancel();
    }

    @Inject(method={"method_60384(Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")}, cancellable=true)
    private void atSuggestComponentRemoval(SuggestionsBuilder suggestionsBuilder, CallbackInfoReturnable<CompletableFuture<Suggestions>> cir) {
        class_1792 item = this.findParsedItem();
        String str = suggestionsBuilder.getRemaining().toLowerCase();
        SuggestionList suggestionList = new SuggestionList();
        DataComponentManager.loadSuggestions(suggestionList, str, this.parsedComponents, item, null, false);
        suggestionList.forEach(s -> s.suggest(suggestionsBuilder));
        cir.setReturnValue((Object)suggestionsBuilder.buildFuture());
        cir.cancel();
    }

    @Unique
    @Nullable
    private class_2960 findParsedItemId() {
        if (this.cursorBeforeItem == -1) {
            return null;
        }
        class_2960 resLoc = null;
        int currentCursor = this.field_48971.getCursor();
        this.field_48971.setCursor(this.cursorBeforeItem);
        try {
            resLoc = class_2960.method_12835((StringReader)this.field_48971);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        this.field_48971.setCursor(currentCursor);
        return resLoc;
    }

    @Unique
    @Nullable
    private class_1792 findParsedItem() {
        class_2960 resLoc = this.findParsedItemId();
        if (resLoc == null) {
            return null;
        }
        return RegistryUtils.ITEM.get(resLoc);
    }

    @Unique
    private CompletableFuture<Suggestions> suggestComponentData(SuggestionsBuilder suggestionsBuilder) {
        NbtSuggestion component;
        class_2960 resLoc = this.lastAdded != null ? RegistryUtils.DATA_COMPONENT_TYPE.getKey(this.lastAdded) : null;
        NbtSuggestion nbtSuggestion = component = resLoc != null ? DataComponentManager.componentMap.get("item/" + String.valueOf(resLoc)) : null;
        if (component == null || this.cursorBeforeComponent == -1) {
            return suggestionsBuilder.buildFuture();
        }
        String tag = this.field_48971.getString().substring(this.cursorBeforeComponent);
        class_2960 itemId = this.findParsedItemId();
        SuggestionList suggestionList = new SuggestionList();
        CustomTagParser tagParser = new CustomTagParser(tag, CustomTagParser.Type.COMPONENT);
        CustomTagParser.Suggestion suggestion = tagParser.read(suggestionList, component, itemId != null ? itemId.toString() : null);
        int cursorShift = this.cursorBeforeComponent + tagParser.getCursor() - suggestionsBuilder.getStart();
        return NbtSuggestionManager.finishSuggestions(suggestionList, suggestionsBuilder, suggestion, cursorShift);
    }
}

