/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.utils.Utils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1299;
import net.minecraft.class_2179;
import net.minecraft.class_2267;
import net.minecraft.class_2300;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_2179.class})
public abstract class CompoundTagArgumentMixin
implements ArgumentType<class_2487> {
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        try {
            String name = this.getResourceName(commandContext);
            if (name == null) {
                return Suggestions.empty();
            }
            String tag = suggestionsBuilder.getRemaining();
            return NbtSuggestionManager.loadFromName(name, tag, suggestionsBuilder, false);
        }
        catch (Exception exception) {
            return Suggestions.empty();
        }
    }

    @Unique
    @Nullable
    private String getResourceName(CommandContext<?> ctx) {
        String commandName;
        switch (commandName = Utils.getCommandName(ctx)) {
            case "summon": {
                class_1299 entityType = (class_1299)((class_6880.class_6883)ctx.getArgument("entity", class_6880.class_6883.class)).comp_349();
                class_2960 resourceLocation = class_1299.method_5890((class_1299)entityType);
                return "entity/" + String.valueOf(resourceLocation);
            }
            case "data": {
                return this.getResourceNameForDataCommand(ctx);
            }
        }
        if (ctx.getChild() != null) {
            return this.getResourceName(ctx.getChild());
        }
        return null;
    }

    @Unique
    @Nullable
    private String getResourceNameForDataCommand(CommandContext<?> ctx) {
        String targetType;
        String instruction = Utils.getNodeString(ctx, 1);
        if (!instruction.equals("merge")) {
            return null;
        }
        switch (targetType = Utils.getNodeString(ctx, 2)) {
            case "block": {
                class_2267 coords = (class_2267)ctx.getArgument("targetPos", class_2267.class);
                return Utils.blockFromCoords(coords);
            }
            case "entity": {
                class_2300 entitySelector = (class_2300)ctx.getArgument("target", class_2300.class);
                return Utils.entityFromEntitySelector(entitySelector);
            }
        }
        return null;
    }
}

