/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.TypeLoader;
import com.mt1006.nbt_ac.autocomplete.suggestions.ComponentSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagIdSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.utils.Fields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1738;
import net.minecraft.class_1742;
import net.minecraft.class_1744;
import net.minecraft.class_1747;
import net.minecraft.class_1749;
import net.minecraft.class_1759;
import net.minecraft.class_1764;
import net.minecraft.class_1780;
import net.minecraft.class_1781;
import net.minecraft.class_1790;
import net.minecraft.class_1792;
import net.minecraft.class_1801;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1808;
import net.minecraft.class_1812;
import net.minecraft.class_1826;
import net.minecraft.class_1833;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_2172;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2435;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7430;
import net.minecraft.class_8168;
import net.minecraft.class_8934;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DataComponentManager {
    private static final NbtSuggestion UNKNOWN_COMPONENT = new NbtSuggestion("nbt_ac:empty", NbtSuggestion.Type.UNKNOWN);
    public static final Map<String, NbtSuggestion> componentMap = new HashMap<String, NbtSuggestion>();

    public static void loadSuggestions(SuggestionList suggestionList, String str, Set<class_9331<?>> usedComponents, @Nullable class_1792 item, @Nullable CustomTagParser.Type parserType, boolean addSuffix) {
        ArrayList entryList = new ArrayList();
        class_2172.method_9268(RegistryUtils.DATA_COMPONENT_TYPE.entrySet(), (String)str, entry -> ((class_5321)entry.getKey()).method_29177(), entryList::add);
        Set<class_9331<?>> predefinedComponents = DataComponentManager.getPredefinedComponents(item);
        Set<class_9331<?>> hardcodedRelevancy = DataComponentManager.getHardcodedRelevant(item);
        for (Map.Entry entry2 : entryList) {
            boolean relevant;
            class_2960 resLoc = ((class_5321)entry2.getKey()).method_29177();
            class_9331 componentType = (class_9331)entry2.getValue();
            if (componentType.method_57875() == null || usedComponents.contains(componentType)) continue;
            NbtSuggestion component = componentMap.get("item/" + String.valueOf(resLoc));
            if (component == null) {
                component = UNKNOWN_COMPONENT;
            }
            boolean bl = relevant = predefinedComponents.contains(componentType) || hardcodedRelevancy.contains(componentType) || component.isAlwaysRelevant();
            if (parserType != null) {
                suggestionList.add(new TagIdSuggestion(component, resLoc, parserType, relevant));
                continue;
            }
            String subtext = component.getSubtext();
            suggestionList.add(new ComponentSuggestion(resLoc, subtext, relevant, addSuffix));
        }
    }

    private static Set<class_9331<?>> getPredefinedComponents(@Nullable class_1792 item) {
        if (item == null) {
            return Set.of();
        }
        return item.method_57347().method_57831();
    }

    private static Set<class_9331<?>> getHardcodedRelevant(@Nullable class_1792 item) {
        if (item == null) {
            return Set.of();
        }
        HashSet relevant = new HashSet();
        if (((Boolean)ModConfig.showCustomDataAsRelevant.val).booleanValue()) {
            relevant.add(class_9334.field_49628);
        }
        if (((Boolean)ModConfig.showCustomModelDataAsRelevant.val).booleanValue()) {
            relevant.add(class_9334.field_49637);
        }
        if (item.method_40131().method_40220(class_3489.field_48803)) {
            relevant.add(class_9334.field_49644);
        }
        if (Fields.isMethodOverridden(Fields.itemAppendHoverTextMethodData, item, class_1792.class)) {
            relevant.add(class_9334.field_49638);
        }
        if (item instanceof class_1826 || item instanceof class_1790 || item instanceof class_1742 || item instanceof class_1808 || item instanceof class_1749) {
            relevant.add(class_9334.field_49609);
        }
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            relevant.add(class_9334.field_49634);
            if (!block.method_9564().method_28501().isEmpty()) {
                relevant.add(class_9334.field_49623);
            }
            if (block instanceof class_2343) {
                DataComponentManager.getHardcodedBlockEntityRelevant(relevant, block);
            }
            if (block instanceof class_8168) {
                relevant.add(class_9334.field_49621);
            }
            if (block instanceof class_2435) {
                relevant.add(class_9334.field_49618);
                relevant.add(class_9334.field_49617);
            }
        } else {
            if (item == class_1802.field_8688) {
                relevant.add(class_9334.field_49608);
            }
            if (item == class_1802.field_50140) {
                relevant.add(class_9334.field_50238);
            }
            if (item == class_1802.field_8598) {
                relevant.add(class_9334.field_49643);
            }
            if (item instanceof class_1780) {
                relevant.add(class_9334.field_49615);
            }
            if (item instanceof class_1781) {
                relevant.add(class_9334.field_49616);
            }
            if (item instanceof class_7430) {
                relevant.add(class_9334.field_49612);
            }
            if (item instanceof class_1764) {
                relevant.add(class_9334.field_49649);
            }
            if (item instanceof class_1744) {
                relevant.add(class_9334.field_49642);
            }
            if (item instanceof class_1759) {
                relevant.add(class_9334.field_49614);
            }
            if (item instanceof class_1801) {
                relevant.add(class_9334.field_49613);
            }
            if (item instanceof class_1840) {
                relevant.add(class_9334.field_49653);
            }
            if (item instanceof class_1843) {
                relevant.add(class_9334.field_49606);
            }
            if (item instanceof class_1738) {
                relevant.add(class_9334.field_49607);
            }
            if (item instanceof class_1812 || item instanceof class_1833) {
                relevant.add(class_9334.field_49651);
            }
            if (item instanceof class_1806) {
                relevant.add(class_9334.field_49645);
                relevant.add(class_9334.field_49647);
                relevant.add(class_9334.field_49646);
            }
            if (Fields.isMethodOverridden(Fields.itemUseOnMethodData, item, class_1792.class)) {
                relevant.add(class_9334.field_49634);
            }
        }
        return relevant;
    }

    private static void getHardcodedBlockEntityRelevant(Set<class_9331<?>> relevant, class_2248 block) {
        relevant.add(class_9334.field_49611);
        class_2586 blockEntity = TypeLoader.blockEntityFromBlock(block);
        if (blockEntity instanceof class_1263) {
            relevant.add(class_9334.field_49622);
            if (blockEntity instanceof class_8934) {
                relevant.add(class_9334.field_49626);
            }
            if (blockEntity instanceof class_2624) {
                relevant.add(class_9334.field_49625);
            }
        }
    }
}

