/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestionSubtype;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import java.util.HashMap;
import net.minecraft.class_2522;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CustomTagParser {
    private static final NbtSuggestion JSON_DUMMY_NBT_SUGGESTION = new NbtSuggestion("nbt_ac:json_dummy", NbtSuggestion.Type.LIST, NbtSuggestion.Source.DEFAULT, NbtSuggestion.Type.COMPOUND);
    private final StringReader reader;
    private final Type parserType;
    @Nullable
    public NbtSuggestion lastFoundSuggestion = null;

    public CustomTagParser(String tag, Type parserType) {
        this.reader = new StringReader(tag);
        this.parserType = parserType;
    }

    public static Pair<Suggestion, Integer> parseJsonComponent(SuggestionList suggestionList, String str, boolean inner) {
        SuggestionList jsonSuggestions;
        if (!inner && !Loader.finished) {
            return Pair.of((Object)((Object)Suggestion.NONE), (Object)0);
        }
        boolean isList = str.startsWith("[");
        CustomTagParser.JSON_DUMMY_NBT_SUGGESTION.subtype = NbtSuggestionSubtype.JSON_TEXT_COMPOUND;
        CustomTagParser jsonParser = new CustomTagParser(str, isList ? Type.JSON_LIST : Type.JSON);
        Suggestion jsonSuggestion = jsonParser.read(jsonSuggestions = new SuggestionList(), JSON_DUMMY_NBT_SUGGESTION, null);
        if (jsonSuggestion == Suggestion.TAG) {
            suggestionList.replaceWith(jsonSuggestions);
        }
        return Pair.of((Object)((Object)jsonSuggestion.asJsonSuggestion(inner)), (Object)jsonParser.getCursor());
    }

    public static Pair<Suggestion, Integer> parseJsonStyle(SuggestionList suggestionList, String str) {
        CustomTagParser.JSON_DUMMY_NBT_SUGGESTION.subtype = NbtSuggestionSubtype.JSON_STYLE_COMPOUND;
        CustomTagParser jsonParser = new CustomTagParser(str, Type.JSON);
        SuggestionList jsonSuggestions = new SuggestionList();
        Suggestion jsonSuggestion = jsonParser.read(jsonSuggestions, JSON_DUMMY_NBT_SUGGESTION, null);
        if (jsonSuggestion == Suggestion.TAG) {
            suggestionList.replaceWith(jsonSuggestions);
        }
        return Pair.of((Object)((Object)jsonSuggestion.asJsonSuggestion(false)), (Object)jsonParser.getCursor());
    }

    public SuggestionList prepareSuggestionList(@Nullable NbtSuggestions suggestions, @Nullable String rootTag) {
        SuggestionList suggestionList = new SuggestionList();
        suggestionList.addAll(suggestions, rootTag, this.parserType);
        return suggestionList;
    }

    public Suggestion read(SuggestionList suggestionList, @Nullable NbtSuggestion suggestion, @Nullable String parentTag) {
        try {
            return switch (this.parserType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.readStruct(suggestionList, suggestion, NbtSuggestion.ParentInfo.fromRoot(parentTag), true, false);
                case 1 -> this.readPath(suggestionList);
                case 2 -> this.readStruct(suggestionList, suggestion, NbtSuggestion.ParentInfo.blank(), true, false);
                case 3 -> this.readList(suggestionList, suggestion, NbtSuggestion.ParentInfo.blank(), true);
                case 4 -> this.readValue(suggestionList, suggestion, NbtSuggestion.ParentInfo.fromRoot(parentTag), false);
            };
        }
        catch (CommandSyntaxException ignore) {
            return Suggestion.NONE;
        }
    }

    private Suggestion readPath(SuggestionList suggestionList) throws CommandSyntaxException {
        while (true) {
            Suggestion compoundSuggestion;
            SuggestionList potentialSuggestions;
            String key;
            TagSuggestion tagSuggestion;
            NbtSuggestion foundSuggestion;
            this.lastFoundSuggestion = foundSuggestion = (tagSuggestion = this.matchSuggestions(suggestionList, key = this.readPathKey(), potentialSuggestions = new SuggestionList())) != null ? tagSuggestion.getSourceSuggestion() : null;
            if (!this.reader.canRead()) {
                suggestionList.replaceWith(potentialSuggestions);
                this.reader.setCursor(this.reader.getCursor() - key.length());
                return Suggestion.TAG;
            }
            if (foundSuggestion == null) {
                return Suggestion.NONE;
            }
            if (this.reader.peek() == '[') {
                this.expect('[');
                if (!this.reader.canRead()) {
                    return Suggestion.NONE;
                }
                if (this.reader.peek() == '{') {
                    compoundSuggestion = this.readSubcompound(suggestionList, foundSuggestion, NbtSuggestion.ParentInfo.blank());
                    if (compoundSuggestion != Suggestion.CONTINUE) {
                        return compoundSuggestion;
                    }
                } else {
                    this.reader.readUnquotedString();
                }
                this.expect(']');
            }
            if (!this.reader.canRead()) {
                return Suggestion.NONE;
            }
            if (this.reader.peek() == '{' && (compoundSuggestion = this.readSubcompound(suggestionList, foundSuggestion, NbtSuggestion.ParentInfo.blank())) != Suggestion.CONTINUE) {
                return compoundSuggestion;
            }
            if (!this.reader.canRead()) {
                return Suggestion.NONE;
            }
            this.expect('.');
            suggestionList.clear();
            suggestionList.addAll(foundSuggestion.subcompound, this.parserType);
        }
    }

    private Suggestion readStruct(SuggestionList suggestionList, @Nullable NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo, boolean isRoot, boolean isMapScanner) throws CommandSyntaxException {
        if (suggestion != null) {
            if (!isMapScanner) {
                SuggestionList tempSuggestionList = new SuggestionList();
                HashMap<String, String> tempTagMap = new HashMap<String, String>();
                NbtSuggestion.ParentInfo tempParentInfo = parentInfo.withTagMap(tempTagMap);
                tempSuggestionList.addAll(suggestion.subcompound, this.parserType);
                suggestion.getSubtypeTagSuggestions(tempSuggestionList, tempParentInfo, this.parserType);
                int oldPos = this.reader.getCursor();
                try {
                    this.readStruct(tempSuggestionList, suggestion, tempParentInfo, true, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                suggestion.getSubtypeTagSuggestions(suggestionList, tempParentInfo, this.parserType);
                this.reader.setCursor(oldPos);
            } else {
                suggestion.getSubtypeTagSuggestions(suggestionList, parentInfo, this.parserType);
            }
        }
        if (!this.reader.canRead()) {
            return Suggestion.COMPOUND_BEGIN;
        }
        this.expect('{');
        if (this.reader.canRead() && this.reader.peek() == '}') {
            this.expect('}');
            return isRoot ? Suggestion.END : Suggestion.CONTINUE;
        }
        do {
            this.reader.skipWhitespace();
            ReadResults readResults = this.readPartialString();
            String key = readResults.str;
            if (key.isEmpty()) {
                this.reader.setCursor(this.reader.getCursor() - readResults.fullLength());
                return Suggestion.TAG;
            }
            parentInfo.putTag(key, null);
            SuggestionList potentialSuggestions = new SuggestionList();
            TagSuggestion foundSuggestion = this.matchSuggestions(suggestionList, key, potentialSuggestions);
            if (!this.reader.canRead()) {
                if (foundSuggestion != null && readResults.finished) {
                    return Suggestion.COLON;
                }
                suggestionList.replaceWith(potentialSuggestions);
                this.reader.setCursor(this.reader.getCursor() - readResults.fullLength());
                return Suggestion.TAG;
            }
            if (foundSuggestion != null) {
                suggestionList.remove(foundSuggestion);
            }
            this.expect(':');
            NbtSuggestion nbtSuggestion = foundSuggestion != null ? foundSuggestion.getSourceSuggestion() : null;
            Suggestion suggestionForValue = this.readValue(suggestionList, nbtSuggestion, parentInfo, false);
            if (suggestionForValue == Suggestion.CONTINUE) continue;
            return suggestionForValue;
        } while (this.readElementSeparator());
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            this.expect('}');
            return isRoot ? Suggestion.END : Suggestion.CONTINUE;
        }
        if (suggestionList.isEmpty()) {
            return Suggestion.COMPOUND_END;
        }
        return Suggestion.COMMA_OR_COMPOUND_END;
    }

    private String readPathKey() throws CommandSyntaxException {
        if (!this.reader.canRead()) {
            return "";
        }
        if (this.reader.peek() == '\'' || this.reader.peek() == '\"') {
            return this.reader.readQuotedString();
        }
        int start = this.reader.getCursor();
        while (this.reader.canRead() && StringReader.isAllowedInUnquotedString((char)this.reader.peek()) && this.reader.peek() != '.') {
            this.reader.skip();
        }
        return this.reader.getString().substring(start, this.reader.getCursor());
    }

    private Suggestion readValue(SuggestionList suggestionList, @Nullable NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo, boolean fromList) throws CommandSyntaxException {
        char peek;
        this.reader.skipWhitespace();
        char c = peek = this.reader.canRead() ? this.reader.peek() : (char)'\u0000';
        if (peek == '{') {
            return this.readSubcompound(suggestionList, suggestion, parentInfo);
        }
        if (peek == '[') {
            return this.readListOrArray(suggestionList, suggestion, parentInfo);
        }
        return this.readSimpleValue(suggestionList, suggestion, parentInfo, fromList);
    }

    private Suggestion readSimpleValue(SuggestionList suggestionList, @Nullable NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo, boolean fromList) {
        NbtSuggestion.Type expectedType = suggestion != null ? (fromList ? suggestion.listType : suggestion.type) : NbtSuggestion.Type.UNKNOWN;
        this.reader.skipWhitespace();
        int cursor = this.reader.getCursor();
        ReadResults stringResults = this.readPartialString();
        String str = stringResults.str;
        boolean finished = stringResults.finished;
        if (finished && suggestion != null) {
            parentInfo.putTag(suggestion.tag, str);
        }
        if (!this.reader.canRead() || !finished) {
            if (expectedType == NbtSuggestion.Type.STRING && stringResults.quoted && finished) {
                return Suggestion.CONTINUE;
            }
            this.reader.setCursor(cursor);
            if (suggestion == null || expectedType == NbtSuggestion.Type.LIST) {
                return Suggestion.fromNbtType(expectedType);
            }
            if (suggestion.subtype == NbtSuggestionSubtype.JSON_TEXT && (str.startsWith("{") || str.startsWith("[")) && this.reader.peek() == '\'') {
                Pair<Suggestion, Integer> results = CustomTagParser.parseJsonComponent(suggestionList, str, true);
                this.reader.setCursor(cursor + (Integer)results.getRight() + 1);
                return (Suggestion)((Object)results.getLeft());
            }
            if (suggestion.getSubtypeSuggestions(suggestionList, parentInfo, this.parserType)) {
                suggestionList.removeIf(s -> !s.matchUnfinished(str));
                return Suggestion.TAG;
            }
            return Suggestion.fromNbtType(expectedType);
        }
        return Suggestion.CONTINUE;
    }

    private Suggestion readListOrArray(SuggestionList suggestionList, @Nullable NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo) throws CommandSyntaxException {
        if (this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';') {
            this.readArray();
            return Suggestion.CONTINUE;
        }
        return this.readList(suggestionList, suggestion, parentInfo, false);
    }

    private Suggestion readList(SuggestionList suggestionList, NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo, boolean isRoot) throws CommandSyntaxException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ']') {
            this.expect(']');
            return isRoot ? Suggestion.END : Suggestion.CONTINUE;
        }
        do {
            Suggestion valueSuggestion;
            if ((valueSuggestion = this.readValue(suggestionList, suggestion, parentInfo, true)) == Suggestion.CONTINUE) continue;
            return valueSuggestion;
        } while (this.readElementSeparator());
        if (this.reader.canRead()) {
            this.expect(']');
            return isRoot ? Suggestion.END : Suggestion.CONTINUE;
        }
        return Suggestion.COMMA_OR_LIST_END;
    }

    private void readArray() throws CommandSyntaxException {
        this.expect('[');
        char key = this.reader.read();
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw class_2522.field_11608.createWithContext((ImmutableStringReader)this.reader);
        }
        if (key != 'B' && key != 'L' && key != 'I') {
            throw class_2522.field_11608.createWithContext((ImmutableStringReader)this.reader);
        }
        this.readArrayElements();
    }

    private void readArrayElements() throws CommandSyntaxException {
        while (this.reader.peek() != ']') {
            this.readValue(null, null, NbtSuggestion.ParentInfo.blank(), false);
            if (!this.readElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw class_2522.field_11605.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
    }

    private Suggestion readSubcompound(SuggestionList suggestionList, @Nullable NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo) throws CommandSyntaxException {
        Suggestion substructSuggestion;
        SuggestionList newSuggestionList = new SuggestionList();
        if (suggestion != null) {
            newSuggestionList.addAll(suggestion.subcompound, this.parserType);
        }
        if ((substructSuggestion = this.readStruct(newSuggestionList, suggestion, parentInfo.createChild(suggestion), false, false)) == Suggestion.TAG) {
            suggestionList.replaceWith(newSuggestionList);
        }
        return substructSuggestion;
    }

    private TagSuggestion matchSuggestions(SuggestionList suggestionList, String key, SuggestionList potentialSuggestions) {
        for (CustomSuggestion customSuggestion : suggestionList) {
            if (customSuggestion instanceof TagSuggestion && customSuggestion.match(key)) {
                return (TagSuggestion)customSuggestion;
            }
            if (!customSuggestion.matchUnfinished(key)) continue;
            potentialSuggestions.add(customSuggestion);
        }
        return null;
    }

    private ReadResults readPartialString() {
        if (!this.reader.canRead()) {
            return new ReadResults("", true, false);
        }
        char quoteChar = this.reader.peek();
        if (!StringReader.isQuotedStringStart((char)quoteChar)) {
            return new ReadResults(this.reader.readUnquotedString(), true, false);
        }
        this.reader.skip();
        StringBuilder stringBuilder = new StringBuilder();
        boolean escaped = false;
        while (this.reader.canRead()) {
            char ch = this.reader.read();
            if (escaped) {
                if (ch != quoteChar && ch != '\\') {
                    return new ReadResults(stringBuilder.toString(), false, true);
                }
                stringBuilder.append(ch);
                escaped = false;
                continue;
            }
            if (ch == quoteChar) {
                return new ReadResults(stringBuilder.toString(), true, true);
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            stringBuilder.append(ch);
        }
        return new ReadResults(stringBuilder.toString(), false, true);
    }

    private boolean readElementSeparator() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char ch) throws CommandSyntaxException {
        this.reader.skipWhitespace();
        this.reader.expect(ch);
        this.reader.skipWhitespace();
    }

    public int getCursor() {
        return this.reader.getCursor();
    }

    public static enum Type {
        COMPOUND(false, false),
        PATH(false, true),
        JSON(true, false),
        JSON_LIST(true, false),
        COMPONENT(false, false);

        public final boolean requiresDoubleQuotes;
        public final boolean requiresNamespace;

        private Type(boolean requiresDoubleQuotes, boolean requiresNamespace) {
            this.requiresDoubleQuotes = requiresDoubleQuotes;
            this.requiresNamespace = requiresNamespace;
        }
    }

    public static enum Suggestion {
        TAG,
        COLON,
        COMPOUND_BEGIN,
        COMPOUND_END,
        COMMA_OR_COMPOUND_END,
        LIST_BEGIN,
        COMMA_OR_LIST_END,
        BOOLEAN,
        STRING,
        BYTE_ARRAY,
        INT_ARRAY,
        LONG_ARRAY,
        TYPE_BYTE,
        TYPE_SHORT,
        TYPE_INT,
        TYPE_LONG,
        TYPE_FLOAT,
        TYPE_DOUBLE,
        JSON_END,
        JSON_BOOLEAN,
        NONE,
        CONTINUE,
        END;

        private static final String[] ALT_BOOLEAN_SUGGESTIONS;
        private final String[] constSuggestionList = this.getConstSuggestions();

        public void suggest(SuggestionsBuilder suggestionsBuilder) {
            String typeString = this.getTypeName();
            if (typeString != null) {
                typeString = String.format("[%s]", typeString);
            }
            for (String suggestion : this.getSuggestions()) {
                if (!suggestion.startsWith(suggestionsBuilder.getRemaining())) continue;
                String type = !suggestion.isEmpty() && typeString != null ? " " + typeString : typeString;
                NbtSuggestionManager.simpleSuggestion(suggestion, type, suggestionsBuilder);
            }
        }

        private String[] getSuggestions() {
            return this == BOOLEAN && (Boolean)ModConfig.shortBoolean.val != false ? ALT_BOOLEAN_SUGGESTIONS : this.constSuggestionList;
        }

        private String[] getConstSuggestions() {
            String[] stringArray;
            switch (this.ordinal()) {
                case 1: {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ":";
                    break;
                }
                case 2: {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "{";
                    break;
                }
                case 3: {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = "}";
                    break;
                }
                case 4: {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = ",";
                    stringArray = stringArray5;
                    stringArray5[1] = "}";
                    break;
                }
                case 5: {
                    String[] stringArray6 = new String[1];
                    stringArray = stringArray6;
                    stringArray6[0] = "[";
                    break;
                }
                case 6: {
                    String[] stringArray7 = new String[2];
                    stringArray7[0] = ",";
                    stringArray = stringArray7;
                    stringArray7[1] = "]";
                    break;
                }
                case 8: {
                    String[] stringArray8 = new String[1];
                    stringArray = stringArray8;
                    stringArray8[0] = "\"";
                    break;
                }
                case 9: {
                    String[] stringArray9 = new String[1];
                    stringArray = stringArray9;
                    stringArray9[0] = "[B;";
                    break;
                }
                case 10: {
                    String[] stringArray10 = new String[1];
                    stringArray = stringArray10;
                    stringArray10[0] = "[I;";
                    break;
                }
                case 11: {
                    String[] stringArray11 = new String[1];
                    stringArray = stringArray11;
                    stringArray11[0] = "[L;";
                    break;
                }
                case 7: 
                case 19: {
                    String[] stringArray12 = new String[2];
                    stringArray12[0] = "true";
                    stringArray = stringArray12;
                    stringArray12[1] = "false";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    String[] stringArray13 = new String[1];
                    stringArray = stringArray13;
                    stringArray13[0] = "";
                    break;
                }
                case 18: {
                    String[] stringArray14 = new String[1];
                    stringArray = stringArray14;
                    stringArray14[0] = "'";
                    break;
                }
                default: {
                    stringArray = new String[]{};
                }
            }
            return stringArray;
        }

        private String getTypeName() {
            return switch (this.ordinal()) {
                case 12 -> NbtSuggestion.Type.BYTE.getName();
                case 13 -> NbtSuggestion.Type.SHORT.getName();
                case 14 -> NbtSuggestion.Type.INT.getName();
                case 15 -> NbtSuggestion.Type.LONG.getName();
                case 16 -> NbtSuggestion.Type.FLOAT.getName();
                case 17 -> NbtSuggestion.Type.DOUBLE.getName();
                case 7, 19 -> NbtSuggestion.Type.BOOLEAN.getName();
                case 8 -> NbtSuggestion.Type.STRING.getName();
                case 9 -> NbtSuggestion.Type.BYTE_ARRAY.getName();
                case 10 -> NbtSuggestion.Type.INT_ARRAY.getName();
                case 11 -> NbtSuggestion.Type.LONG_ARRAY.getName();
                default -> null;
            };
        }

        public Suggestion asJsonSuggestion(boolean inner) {
            return switch (this.ordinal()) {
                case 7 -> JSON_BOOLEAN;
                case 22 -> {
                    if (inner) {
                        yield JSON_END;
                    }
                    yield END;
                }
                default -> this;
            };
        }

        public static Suggestion fromNbtType(NbtSuggestion.Type type) {
            return switch (type) {
                case NbtSuggestion.Type.STRING -> STRING;
                case NbtSuggestion.Type.COMPOUND -> COMPOUND_BEGIN;
                case NbtSuggestion.Type.LIST -> LIST_BEGIN;
                case NbtSuggestion.Type.BOOLEAN -> BOOLEAN;
                case NbtSuggestion.Type.BYTE_ARRAY -> BYTE_ARRAY;
                case NbtSuggestion.Type.LONG_ARRAY -> LONG_ARRAY;
                case NbtSuggestion.Type.BYTE -> TYPE_BYTE;
                case NbtSuggestion.Type.SHORT -> TYPE_SHORT;
                case NbtSuggestion.Type.INT -> TYPE_INT;
                case NbtSuggestion.Type.LONG -> TYPE_LONG;
                case NbtSuggestion.Type.FLOAT -> TYPE_FLOAT;
                case NbtSuggestion.Type.DOUBLE -> TYPE_DOUBLE;
                case NbtSuggestion.Type.INT_ARRAY, NbtSuggestion.Type.UUID -> INT_ARRAY;
                default -> NONE;
            };
        }

        static {
            ALT_BOOLEAN_SUGGESTIONS = new String[]{"1b", "0b"};
        }
    }

    private record ReadResults(String str, boolean finished, boolean quoted) {
        public int fullLength() {
            return this.str.length() + (this.quoted ? 1 : 0);
        }
    }
}

