/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.resource;

import com.ibm.icu.lang.UCharacter;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolList {
    private final class_2960 id;
    protected final List<String> symbols;

    public SymbolList(class_2960 id, List<String> symbols) {
        this.id = id;
        this.symbols = symbols;
    }

    public class_2960 getId() {
        return this.id;
    }

    public Stream<String> stream() {
        return this.symbols.stream();
    }

    public static class SplitType {
        private final Function<BufferedReader, List<String>> splitter;
        private static final Map<String, SplitType> TYPES = new HashMap<String, SplitType>();
        public static final SplitType CODEPOINT = SplitType.register("codepoint", new SplitType(reader -> reader.lines().flatMapToInt(String::codePoints).mapToObj(UCharacter::toString).toList()));
        public static final SplitType LINE = SplitType.register("line", new SplitType(reader -> reader.lines().toList()));

        public SplitType(Function<BufferedReader, List<String>> splitter) {
            this.splitter = splitter;
        }

        public List<String> split(BufferedReader reader) {
            return this.splitter.apply(reader);
        }

        public static SplitType register(String name, SplitType splitType) {
            TYPES.put(name, splitType);
            return splitType;
        }

        @NotNull
        public static SplitType getOrDefault(String name, @NotNull SplitType defaultType) {
            SplitType splitType = SplitType.get(name);
            return splitType == null ? defaultType : splitType;
        }

        @Nullable
        public static SplitType get(String name) {
            return TYPES.get(name);
        }
    }

    public static class Mutable
    extends SymbolList {
        private final HashSet<String> set = new HashSet();

        public Mutable(class_2960 id, List<String> symbols) {
            super(id, new ArrayList<String>(symbols));
            this.set.addAll(symbols);
        }

        public Mutable(class_2960 id) {
            super(id, new ArrayList<String>());
        }

        public void addSymbol(String symbol) {
            this.symbols.add(symbol);
            this.set.add(symbol);
        }

        public boolean contains(String symbol) {
            return this.set.contains(symbol);
        }

        public void clear() {
            this.symbols.clear();
            this.set.clear();
        }
    }
}

