/*
 * Decompiled with CFR 0.152.
 */
package com.thegameratort.titlefixer.mixin;

import com.thegameratort.titlefixer.TitleFixer;
import com.thegameratort.titlefixer.TitleRenderInfo;
import com.thegameratort.titlefixer.config.ScoreboardMode;
import com.thegameratort.titlefixer.config.TitleFixerConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10209;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Final
    @Shadow
    private class_310 field_2035;
    @Shadow
    private int field_2017;
    @Shadow
    private class_2561 field_2016;
    @Shadow
    private class_2561 field_2039;
    @Shadow
    private int field_2037;
    @Shadow
    private int field_2023;
    @Shadow
    private int field_2036;
    @Unique
    private class_2561 titlec;
    @Unique
    private int scoreboardWidth = -1;
    @Unique
    private int scoreboardOpacityGain = 0;
    @Unique
    public boolean renderTitle = false;
    @Unique
    public boolean hideScoreboard = false;
    @Unique
    public final TitleRenderInfo titleRI = new TitleRenderInfo();
    @Unique
    public final TitleRenderInfo subtitleRI = new TitleRenderInfo();

    @Shadow
    public abstract class_327 method_1756();

    @Inject(method={"render(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V"}, at={@At(value="HEAD")})
    private void preRenderHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        this.scoreboardWidth = -1;
        this.hideScoreboard = false;
        this.titlec = this.field_2016;
        this.field_2016 = null;
        this.collectRenderInfo(context);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V"}, at={@At(value="TAIL")})
    private void postRenderHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        this.field_2016 = this.titlec;
    }

    @Unique
    private void collectRenderInfo(class_332 context) {
        boolean bl = this.renderTitle = this.titlec != null && this.field_2023 > 0;
        if (this.renderTitle) {
            TitleFixerConfig config = TitleFixer.getConfig();
            class_327 textRenderer = this.method_1756();
            int titleWidth = textRenderer.method_27525((class_5348)this.titlec);
            this.collectTitleRenderInfo(context, this.titleRI, config.preferredTitleScale, titleWidth, config);
            if (this.field_2039 != null) {
                int subtitleWidth = textRenderer.method_27525((class_5348)this.field_2039);
                this.collectTitleRenderInfo(context, this.subtitleRI, config.preferredSubtitleScale, subtitleWidth, config);
            }
        }
    }

    @Unique
    private void collectTitleRenderInfo(class_332 context, TitleRenderInfo ri, float titleScale, int titleWidth, TitleFixerConfig config) {
        int scaledWidth = context.method_51421();
        int scaledHeight = context.method_51443();
        float renderScale = titleScale;
        int renderAreaWidth = scaledWidth - config.titleMarginLeft - config.titleMarginRight;
        int renderAreaWidthSB = renderAreaWidth - this.scoreboardWidth;
        if (config.scoreboardMode == ScoreboardMode.FADE) {
            renderAreaWidthSB -= this.scoreboardWidth;
        }
        boolean hitBoundary = false;
        int renderTextWidth = (int)(renderScale * (float)titleWidth);
        if (renderTextWidth > renderAreaWidthSB) {
            if (config.scoreboardMode == ScoreboardMode.FADE) {
                this.hideScoreboard = true;
                if (config.titleAlwaysFitsScreen && renderTextWidth > renderAreaWidth) {
                    renderScale = (float)renderAreaWidth / (float)titleWidth;
                    hitBoundary = true;
                }
            } else if (config.titleAlwaysFitsScreen) {
                renderScale = config.scoreboardMode == ScoreboardMode.MOVE ? (float)renderAreaWidthSB / (float)titleWidth : (float)renderAreaWidth / (float)titleWidth;
                hitBoundary = true;
            }
        }
        float titlePosX = (float)scaledWidth / 2.0f;
        float titlePosY = (float)scaledHeight / 2.0f;
        if (config.scoreboardMode == ScoreboardMode.MOVE) {
            titlePosX -= (float)this.scoreboardWidth / 2.0f;
        }
        if (hitBoundary) {
            titlePosX += (float)(config.titleMarginLeft - config.titleMarginRight) / 2.0f;
        }
        ri.posX = titlePosX;
        ri.posY = titlePosY;
        ri.scale = renderScale;
    }

    @Inject(method={"renderTitleAndSubtitle(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V"}, at={@At(value="HEAD")})
    private void renderTitleAndSubtitle_hook(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (this.renderTitle) {
            class_3695 profiler = class_10209.method_64146();
            class_327 textRenderer = this.method_1756();
            profiler.method_15396("titleAndSubtitle");
            float ticksLeft = (float)this.field_2023 - tickCounter.method_60637(false);
            int alpha = 255;
            if (this.field_2023 > this.field_2036 + this.field_2017) {
                float r = (float)(this.field_2037 + this.field_2017 + this.field_2036) - ticksLeft;
                alpha = (int)(r * 255.0f / (float)this.field_2037);
            }
            if (this.field_2023 <= this.field_2036) {
                alpha = (int)(ticksLeft * 255.0f / (float)this.field_2036);
            }
            if ((alpha = class_3532.method_15340((int)alpha, (int)0, (int)255)) > 8) {
                class_4587 matrices = context.method_51448();
                matrices.method_22903();
                matrices.method_46416(this.titleRI.posX, this.titleRI.posY, 0.0f);
                matrices.method_22903();
                matrices.method_22905(this.titleRI.scale, this.titleRI.scale, 1.0f);
                int titleColor = class_9848.method_61330((int)alpha, (int)-1);
                int titleWidth = textRenderer.method_27525((class_5348)this.titlec);
                context.method_60649(textRenderer, this.titlec, -titleWidth / 2, -10, titleWidth, titleColor);
                matrices.method_22909();
                if (this.field_2039 != null) {
                    matrices.method_22903();
                    matrices.method_22905(this.subtitleRI.scale, this.subtitleRI.scale, 1.0f);
                    int subtitleWidth = textRenderer.method_27525((class_5348)this.field_2039);
                    context.method_60649(textRenderer, this.field_2039, -subtitleWidth / 2, 5, subtitleWidth, titleColor);
                    matrices.method_22909();
                }
                matrices.method_22909();
            }
            profiler.method_15407();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    void tick_hook(CallbackInfo ci) {
        TitleFixerConfig config = TitleFixer.getConfig();
        if (this.hideScoreboard) {
            if (this.scoreboardOpacityGain > -255) {
                this.scoreboardOpacityGain -= config.scoreboardFadeSpeed;
                if (this.scoreboardOpacityGain < -255) {
                    this.scoreboardOpacityGain = -255;
                }
            }
        } else if (this.scoreboardOpacityGain < 0) {
            this.scoreboardOpacityGain += config.scoreboardFadeSpeed;
            if (this.scoreboardOpacityGain > 0) {
                this.scoreboardOpacityGain = 0;
            }
        }
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderScoreboardSidebar_hook0(class_332 context, class_266 objective, CallbackInfo ci) {
        if (this.getNewScoreboardColor(-1) >>> 24 <= 8) {
            ci.cancel();
        }
    }

    @ModifyArgs(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V"))
    private void renderScoreboardSidebar_hook1(Args args) {
        if (this.scoreboardWidth == -1) {
            int x1 = (Integer)args.get(0);
            int x2 = (Integer)args.get(2);
            this.scoreboardWidth = x2 - x1;
        }
        args.set(4, (Object)this.getNewScoreboardColor((Integer)args.get(4)));
    }

    @ModifyArg(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIIZ)I"), index=4)
    private int renderScoreboardSidebar_hook2(int color) {
        return this.getNewScoreboardColor(color);
    }

    @Unique
    private int getNewScoreboardColor(int color) {
        TitleFixerConfig config = TitleFixer.getConfig();
        int alpha = color >>> 24;
        if ((alpha += this.scoreboardOpacityGain) < config.scoreboardHideMinAlpha) {
            alpha = config.scoreboardHideMinAlpha;
        } else if (alpha > 255) {
            alpha = 255;
        }
        color &= 0xFFFFFF;
        return color |= alpha << 24;
    }
}

