/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import java.util.function.DoubleUnaryOperator;

public class RotationInterpolator
implements DoubleUnaryOperator {
    private static final double TPI = Math.PI * 2;
    private final double fullRot;
    private Double prevVal;
    private double mul;

    private RotationInterpolator(double fullRot) {
        this.fullRot = fullRot;
    }

    @Override
    public double applyAsDouble(double value) {
        if (this.prevVal == null) {
            this.prevVal = value;
            return value;
        }
        double v1 = Math.abs(value - this.prevVal);
        double v2 = Math.abs(this.fullRot - this.prevVal + value);
        double v3 = Math.abs(this.fullRot + this.prevVal - value);
        this.prevVal = value;
        if (v1 < v2 && v1 < v3) {
            return value + this.mul;
        }
        if (v1 > v2 && v2 < v3) {
            this.mul += this.fullRot;
            return value + this.mul;
        }
        if (v1 > v3 && v2 > v3) {
            this.mul -= this.fullRot;
            return value + this.mul;
        }
        return value;
    }

    public static DoubleUnaryOperator createRad() {
        return new RotationInterpolator(Math.PI * 2);
    }

    public static DoubleUnaryOperator createDeg() {
        return new RotationInterpolator(360.0);
    }
}

