/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template;

import com.tom.cpm.shared.template.Template;
import com.tom.cpm.shared.template.args.AngleArg;
import com.tom.cpm.shared.template.args.BoolArg;
import com.tom.cpm.shared.template.args.ColorArg;
import com.tom.cpm.shared.template.args.Float1Arg;
import com.tom.cpm.shared.template.args.Float2Arg;
import com.tom.cpm.shared.template.args.TexArg;
import java.util.function.Supplier;

public enum TemplateArgumentType {
    COLOR(ColorArg::new),
    TEX(TexArg::new),
    FLOAT1(Float1Arg::new),
    FLOAT2(Float2Arg::new),
    ANGLE(AngleArg::new),
    BOOL(BoolArg::new);

    public static final TemplateArgumentType[] VALUES;
    private final Supplier<Template.IArg> factory;

    private TemplateArgumentType(Supplier<Template.IArg> factory) {
        this.factory = factory;
    }

    public Template.IArg create() {
        return this.factory.get();
    }

    public static TemplateArgumentType lookup(String name) {
        for (TemplateArgumentType t : VALUES) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public static Template.IArg create(String name) {
        TemplateArgumentType type = TemplateArgumentType.lookup(name);
        if (type == null) {
            throw new RuntimeException("Missing arg type");
        }
        return type.create();
    }

    static {
        VALUES = TemplateArgumentType.values();
    }
}

