/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.render.ItemRenderer;
import java.io.IOException;

public class EffectRenderItem
implements IRenderEffect {
    private int id;
    private ItemSlot slot;
    private int slotID;

    public EffectRenderItem() {
    }

    public EffectRenderItem(int id, ItemSlot slot, int slotID) {
        this.id = id;
        this.slot = slot;
        this.slotID = slotID;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        this.id = in.readVarInt();
        this.slot = (ItemSlot)in.readEnum(ItemSlot.VALUES);
        this.slotID = in.readByte();
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVarInt(this.id);
        out.writeEnum(this.slot);
        out.writeByte(this.slotID);
    }

    @Override
    public void apply(ModelDefinition def) {
        RenderedCube cube = def.getElementById(this.id);
        if (cube != null) {
            cube.getCube().size = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.getCube().mcScale = 0.0f;
            cube.itemRenderer = new ItemRenderer(this.slot, this.slotID);
        }
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.ITEM;
    }
}

