/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tags;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.entity.EntityType;
import com.tom.cpl.item.Stack;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.tag.CPMTag;
import com.tom.cpl.tag.IAllTags;
import com.tom.cpl.tag.TagType;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import java.util.List;
import java.util.Map;

public class EditorTags
implements IAllTags {
    private final Editor editor;
    private final AllTagManagers builtinTags = MinecraftClientAccess.get().getBuiltinTags();
    private final EditorTagManager<BlockState> blockTags = new EditorTagManager<BlockState>(this, this.builtinTags.getBlockTags());
    private final EditorTagManager<Stack> itemTags = new EditorTagManager<Stack>(this, this.builtinTags.getItemTags());
    private final EditorTagManager<EntityType> entityTags = new EditorTagManager<EntityType>(this, this.builtinTags.getEntityTags());
    private final EditorTagManager<Biome> biomeTags = new EditorTagManager<Biome>(this, this.builtinTags.getBiomeTags());

    public EditorTags(Editor editor) {
        this.editor = editor;
    }

    public EditorTagManager<BlockState> getBlockTags() {
        return this.blockTags;
    }

    public EditorTagManager<Stack> getItemTags() {
        return this.itemTags;
    }

    public EditorTagManager<EntityType> getEntityTags() {
        return this.entityTags;
    }

    public EditorTagManager<Biome> getBiomeTags() {
        return this.biomeTags;
    }

    public <T> EditorTagManager<T> getByType(TagType type) {
        return (EditorTagManager)IAllTags.super.getByType(type);
    }

    public void clear() {
        this.blockTags.clear();
        this.itemTags.clear();
        this.entityTags.clear();
        this.biomeTags.clear();
    }

    public void markDirty() {
        this.editor.markDirty();
    }

    public <T> void addTagAction(Map<String, CPMTag<T>> tags, String id, CPMTag<T> tag) {
        this.editor.action("add", "button.cpm.tags").addToMap(tags, id, tag).execute();
    }

    public <T> void removeTagAction(Map<String, CPMTag<T>> tags, String id) {
        this.editor.action("remove", "button.cpm.tags").removeFromMap(tags, id).execute();
    }

    public <T> void addTagElemAction(List<String> elems, String elem, Runnable clear) {
        this.editor.action("edit", "button.cpm.tags").addToList(elems, elem).onAction(clear).execute();
    }

    public <T> void removeTagElemAction(List<String> elems, String elem, Runnable clear) {
        this.editor.action("edit", "button.cpm.tags").removeFromList(elems, elem).onAction(clear).execute();
    }
}

