/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.common.PlatformCommon;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.shared.MinecraftServerAccess;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeHandlerImpl
extends BiomeHandler<WorldImpl.BiomeInfo> {
    public static final BiomeHandlerImpl clientImpl = new BiomeHandlerImpl(() -> class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236));
    public static final BiomeHandlerImpl serverImpl = new BiomeHandlerImpl(() -> ((MinecraftServerObject)MinecraftServerAccess.get()).getServer().method_30611().method_30530(class_7924.field_41236));
    private static final class_2338 SEA_LEVEL = new class_2338(0, 64, 0);
    private final Supplier<class_2378<class_1959>> registry;

    public static BiomeHandlerImpl getImpl(class_1937 level) {
        return level.field_9236 ? clientImpl : serverImpl;
    }

    public BiomeHandlerImpl(Supplier<class_2378<class_1959>> registry) {
        this.registry = registry;
    }

    @Override
    public List<Biome> listNativeEntries(String tag) {
        class_2960 rl = class_2960.method_12829((String)tag);
        if (rl == null) {
            return Collections.emptyList();
        }
        class_1959 b = (class_1959)this.registry.get().method_29107(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)rl));
        if (b != null) {
            return Collections.singletonList(this.wrap(new WorldImpl.BiomeInfo((class_6880<class_1959>)this.registry.get().method_47983((Object)b), SEA_LEVEL)));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return this.registry.get().method_40272().map(k -> k.method_40251().comp_327().toString()).toList();
    }

    @Override
    public Biome emptyObject() {
        return this.wrap(null);
    }

    @Override
    public boolean isInTag(String tag, WorldImpl.BiomeInfo state) {
        if (tag.charAt(0) == '#') {
            class_2960 rl = class_2960.method_12829((String)tag.substring(1));
            if (rl != null) {
                class_6862 i = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)rl);
                return state.biome().method_40220(i);
            }
        } else {
            return this.getBiomeId(state).equals(tag);
        }
        return false;
    }

    @Override
    public List<String> listTags(WorldImpl.BiomeInfo state) {
        return state.biome().method_40228().map(k -> "#" + String.valueOf(k.comp_327())).toList();
    }

    @Override
    public List<Biome> getAllElements() {
        return StreamSupport.stream(this.registry.get().method_40295().spliterator(), false).map(e -> this.wrap(new WorldImpl.BiomeInfo((class_6880<class_1959>)e, SEA_LEVEL))).collect(Collectors.toList());
    }

    @Override
    public boolean equals(WorldImpl.BiomeInfo a, WorldImpl.BiomeInfo b) {
        return a.value() == b.value();
    }

    @Override
    public String getBiomeId(WorldImpl.BiomeInfo state) {
        return this.registry.get().method_10221((Object)state.value()).toString();
    }

    @Override
    public float getTemperature(WorldImpl.BiomeInfo state) {
        return state.value().method_8712();
    }

    @Override
    public float getHumidity(WorldImpl.BiomeInfo state) {
        return PlatformCommon.getClimateSettings(state.value()).comp_846();
    }

    @Override
    public BiomeHandler.RainType getRainType(WorldImpl.BiomeInfo state) {
        return BiomeHandler.RainType.get(state.value().method_48162(state.at(), state.at().method_10264()).name());
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.registry.get() != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

