/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.Platform;
import com.tom.cpm.common.ByteArrayPayload;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import java.util.function.Function;
import net.minecraft.class_10034;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4597;
import net.minecraft.class_563;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_634;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public abstract class ClientBase {
    public static final class_2960 DEFAULT_CAPE = class_2960.method_60654((String)"cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    protected class_310 minecraft;
    public RenderManager<GameProfile, class_1657, class_3879, class_4597> manager;
    public NetHandler<class_8710.class_9154<ByteArrayPayload>, class_1657, class_634> netHandler;

    public void init0() {
        this.minecraft = class_310.method_1551();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        irisLoaded = IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, class_1657, class_3879, class_4597>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), class_1657::method_7334);
        this.manager.setGPGetters(GameProfile::getProperties, Property::value);
        this.netHandler = new NetHandler((k, v) -> new class_8710.class_9154(class_2960.method_43902((String)k, (String)v)));
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(Function.identity(), (c, rl, pb) -> c.method_52787((class_2596)new class_2817((class_8710)new ByteArrayPayload((class_8710.class_9154<ByteArrayPayload>)rl, (byte[])pb))));
        this.netHandler.setPlayerToLoader(class_1657::method_7334);
        this.netHandler.setGetPlayerById(id -> {
            class_1297 ent = class_310.method_1551().field_1687.method_8469(id);
            if (ent instanceof class_1657) {
                return (class_1657)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_1724);
        this.netHandler.setGetNet(c -> ((class_746)c).field_3944);
        this.netHandler.setDisplayText(t -> this.minecraft.field_1724.method_7353((class_2561)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(class_1657.class, class_1297::method_5667).renderApi(class_3879.class, class_2960.class, class_1921.class, class_4597.class, GameProfile.class, ModelTexture::new).localModelApi(GameProfile::new).init();
    }

    public void playerRenderPost(class_4597 buffer, class_591 model) {
        this.manager.unbindClear((class_3879)model);
    }

    public void renderHand(class_4597 buffer, class_591 model) {
        this.renderHand((class_742)this.minecraft.field_1724, buffer, model);
    }

    public void renderHand(class_742 pl, class_4597 buffer, class_591 model) {
        this.manager.bindHand((class_1657)pl, buffer, (class_3879)model);
    }

    public void renderHandPost(class_4597 buffer, class_572 model) {
        this.manager.unbindClear((class_3879)model);
    }

    public void renderSkull(class_3879 skullModel, GameProfile profile, class_4597 buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderSkullPost(class_4597 buffer, class_3879 model) {
        this.manager.unbindFlush(model);
    }

    public void renderElytra(class_572<class_10034> player, class_563 model) {
        this.manager.bindElytra((class_3879)player, (class_3879)model);
    }

    public void renderArmor(class_572<class_10034> modelArmor, class_572<class_10034> modelLeggings, class_572<class_10034> player) {
        this.manager.bindArmor((class_3879)player, (class_3879)modelArmor, 1);
        this.manager.bindArmor((class_3879)player, (class_3879)modelLeggings, 2);
    }

    public void updateJump() {
        if (this.minecraft.field_1724.method_24828() && this.minecraft.field_1724.field_3913.field_54155.comp_3163()) {
            this.manager.jump((class_1657)this.minecraft.field_1724);
        }
    }
}

