/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import java.lang.ref.WeakReference;
import java.util.function.Function;

public class WeakStorage<T> {
    private WeakReference<T> ref;

    public void set(T value) {
        if (this.ref == null || this.ref.get() != value) {
            this.ref = new WeakReference<T>(value);
        }
    }

    public T get() {
        return this.ref != null ? (T)this.ref.get() : null;
    }

    public <R> R call(Function<T, R> func, R def) {
        if (this.ref == null) {
            return def;
        }
        Object v = this.ref.get();
        if (v == null) {
            return def;
        }
        return func.apply(v);
    }

    public <N, R> R castCall(Class<N> clz, Function<N, R> func, R def) {
        if (this.ref == null) {
            return def;
        }
        Object v = this.ref.get();
        if (v == null || !clz.isInstance(v)) {
            return def;
        }
        return func.apply(v);
    }
}

