/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.tom.cpl.math.Quaternion;
import com.tom.cpl.math.Vec3f;
import java.util.HashMap;
import java.util.Map;

public class Rotation {
    public float x;
    public float y;
    public float z;

    public Rotation(Vec3f zyx, boolean degrees) {
        this.x = zyx.x;
        this.y = zyx.y;
        this.z = zyx.z;
        if (degrees) {
            this.toRadians();
        }
    }

    private void toRadians() {
        this.x = (float)Math.toRadians(this.x);
        this.y = (float)Math.toRadians(this.y);
        this.z = (float)Math.toRadians(this.z);
    }

    public Rotation() {
    }

    public Rotation(float x, float y, float z, boolean degrees) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (degrees) {
            this.toRadians();
        }
    }

    public Rotation add(Rotation v) {
        return new Rotation(this.x + v.x, this.y + v.y, this.z + v.z, false);
    }

    public Vec3f asVec3f(boolean degrees) {
        if (degrees) {
            return new Vec3f((float)Math.toDegrees(this.x), (float)Math.toDegrees(this.y), (float)Math.toDegrees(this.z));
        }
        return new Vec3f(this.x, this.y, this.z);
    }

    public Quaternion asQ() {
        return new Quaternion(this.x, this.y, this.z, Quaternion.RotationOrder.ZYX, false);
    }

    public Map<String, Object> toMap3() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", Math.toDegrees(this.x));
        map.put("y", Math.toDegrees(this.y));
        map.put("z", Math.toDegrees(this.z));
        return map;
    }
}

