/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.util;

import com.tom.cpl.gui.elements.GuiElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ButtonGroup<S, B extends GuiElement>
implements Consumer<S> {
    private Map<S, Set<B>> map = new HashMap<S, Set<B>>();
    private final BiConsumer<B, Boolean> setSel;
    private final BiConsumer<B, Runnable> setEvent;
    private final Consumer<S> setValue;

    public ButtonGroup(BiConsumer<B, Boolean> setSel, BiConsumer<B, Runnable> setEvent, Consumer<S> setValue) {
        this.setSel = setSel;
        this.setEvent = setEvent;
        this.setValue = setValue;
    }

    public void addElement(S type, B elem) {
        this.map.computeIfAbsent(type, k -> new HashSet()).add(elem);
        this.setEvent.accept(elem, () -> this.setValue(type));
    }

    private void setValue(S type) {
        this.setValue.accept(type);
        this.accept(type);
    }

    public void addElement(S type, Function<Runnable, B> elemF) {
        GuiElement elem = (GuiElement)elemF.apply(() -> this.setValue(type));
        this.map.computeIfAbsent(type, k -> new HashSet()).add(elem);
    }

    @Override
    public void accept(S type) {
        for (Map.Entry<S, Set<B>> e2 : this.map.entrySet()) {
            for (GuiElement elem : e2.getValue()) {
                this.setSel.accept(elem, false);
            }
        }
        this.map.getOrDefault(type, Collections.emptySet()).forEach(e -> this.setSel.accept(e, true));
    }
}

