/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpm.shared.config.Keybind;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class KeybindHandler {
    private final IGui gui;
    private Map<Keybind, KeyHandler> keyHandlers = new HashMap<Keybind, KeyHandler>();

    public KeybindHandler(IGui gui) {
        this.gui = gui;
    }

    public void registerKeybind(Keybind kb, Runnable r) {
        this.keyHandlers.put(kb, new KeyHandler(r, false));
    }

    public void registerKeybindInPopups(Keybind kb, Runnable r) {
        this.keyHandlers.put(kb, new KeyHandler(r, true));
    }

    public void keyEvent(KeyboardEvent evt, boolean popup) {
        if (evt.isConsumed()) {
            return;
        }
        Stream<Object> s = this.keyHandlers.entrySet().stream();
        if (popup) {
            s = s.filter(e -> ((KeyHandler)e.getValue()).inPopups);
        }
        s.sorted(Comparator.comparingInt(e -> -((Keybind)e.getKey()).getMod())).filter(e -> {
            if (((Keybind)e.getKey()).isPressed(this.gui, evt)) {
                ((KeyHandler)e.getValue()).handler.run();
                evt.consume();
            }
            return evt.isConsumed();
        }).findFirst();
        this.keyHandlers.clear();
    }

    private static class KeyHandler {
        private Runnable handler;
        private boolean inPopups;

        public KeyHandler(Runnable handler, boolean inPopups) {
            this.handler = handler;
            this.inPopups = inPopups;
        }
    }
}

