/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.source;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.echo.GuardianEntityLightSource;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.EntityDynamicLightSource;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1297;
import net.minecraft.class_1577;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface EntityDynamicLightSourceBehavior
extends EntityDynamicLightSource {
    public double getDynamicLightPrevX();

    public double getDynamicLightPrevY();

    public double getDynamicLightPrevZ();

    public void updateDynamicLightPreviousCoordinates();

    public void setLuminance(int var1);

    public int getLastDynamicLuminance();

    public void setLastDynamicLuminance(int var1);

    @ApiStatus.Internal
    default public void setDynamicLightEnabled(boolean enabled) {
        this.resetDynamicLight();
        if (enabled) {
            LambDynLights.get().addLightSource(this);
        } else {
            LambDynLights.get().removeLightSource(this);
        }
    }

    public boolean shouldUpdateDynamicLight();

    public static void tickEntity(class_1297 entity) {
        if (!LambDynLights.get().shouldTick()) {
            return;
        }
        EntityDynamicLightSourceBehavior lightSource = (EntityDynamicLightSourceBehavior)entity;
        if (entity.method_31481()) {
            lightSource.setDynamicLightEnabled(false);
        } else {
            if (DynamicLightingEngine.canLightUp(entity)) {
                lightSource.dynamicLightTick();
            } else {
                lightSource.setLuminance(0);
            }
            LambDynLights.updateTracking(lightSource);
        }
        if (entity instanceof class_1577) {
            class_1577 guardian = (class_1577)entity;
            GuardianEntityLightSource.tick(guardian);
        }
    }

    @Override
    default public LongSet getDynamicLightChunksToRebuild(boolean forced) {
        double x = this.getDynamicLightX();
        double y = this.getDynamicLightY();
        double z = this.getDynamicLightZ();
        double deltaX = x - this.getDynamicLightPrevX();
        double deltaY = y - this.getDynamicLightPrevY();
        double deltaZ = z - this.getDynamicLightPrevZ();
        int luminance = this.getLuminance();
        if (!forced && Math.abs(deltaX) <= 0.1 && Math.abs(deltaY) <= 0.1 && Math.abs(deltaZ) <= 0.1 && luminance == this.getLastDynamicLuminance()) {
            return LongSet.of();
        }
        LongOpenHashSet newPos = new LongOpenHashSet();
        if (luminance > 0) {
            DynamicLightSource.gatherClosestChunks((LongSet)newPos, x, y, z);
        }
        LongOpenHashSet result = new LongOpenHashSet((LongCollection)newPos);
        result.addAll((LongCollection)this.lambdynlights$getTrackedLitChunkPos());
        this.updateDynamicLightPreviousCoordinates();
        this.setLastDynamicLuminance(luminance);
        this.lambdynlights$setTrackedLitChunkPos((LongSet)newPos);
        return result;
    }

    public LongSet lambdynlights$getTrackedLitChunkPos();

    public void lambdynlights$setTrackedLitChunkPos(LongSet var1);
}

