/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.util;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import ca.spottedleaf.starlight.common.world.ExtendedSerializableChunkData;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import org.slf4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int STARLIGHT_LIGHT_VERSION = 9;
    private static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    private static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    private static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static int getLightVersion() {
        return 9;
    }

    public static void prepareSaveLightHook(class_2791 chunk, class_2852 data) {
        try {
            SaveUtil.prepareSaveLightHookReal(chunk, data);
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(chunk.method_12004()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void prepareSaveLightHookReal(class_2791 chunk, class_2852 data) {
        ListIterator<class_2852.class_9898> iterator = data.comp_2959().listIterator();
        while (iterator.hasNext()) {
            class_2852.class_9898 sectionData = (class_2852.class_9898)iterator.next();
            iterator.set(new class_2852.class_9898(sectionData.comp_2963(), sectionData.comp_2964(), null, null));
        }
        ((ExtendedSerializableChunkData)data).scalablelux$setBlockLight((SWMRNibbleArray.SaveState[])Arrays.stream(((ExtendedChunk)chunk).getBlockNibbles()).map(SWMRNibbleArray::getSaveState).toArray(SWMRNibbleArray.SaveState[]::new));
        ((ExtendedSerializableChunkData)data).scalablelux$setSkyLight((SWMRNibbleArray.SaveState[])Arrays.stream(((ExtendedChunk)chunk).getSkyNibbles()).map(SWMRNibbleArray::getSaveState).toArray(SWMRNibbleArray.SaveState[]::new));
    }

    public static void prepareSaveVanillaLightHook(class_3218 serverLevel, class_2791 chunk, class_2852 data) {
        boolean lightCorrect = data.comp_2958();
        ((ExtendedSerializableChunkData)data).scalablelux$setLightCorrect(false);
        try {
            SaveUtil.prepareSaveVanillaLightHookReal(serverLevel, chunk, data);
            ((ExtendedSerializableChunkData)data).scalablelux$setLightCorrect(lightCorrect);
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(chunk.method_12004()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void prepareSaveVanillaLightHookReal(class_3218 serverLevel, class_2791 chunk, class_2852 data) {
        SWMRNibbleArray.SaveState[] blockNibbles = (SWMRNibbleArray.SaveState[])Arrays.stream(((ExtendedChunk)chunk).getBlockNibbles()).map(SWMRNibbleArray::getSaveState).toArray(SWMRNibbleArray.SaveState[]::new);
        SWMRNibbleArray.SaveState[] skyNibbles = (SWMRNibbleArray.SaveState[])Arrays.stream(((ExtendedChunk)chunk).getSkyNibbles()).map(SWMRNibbleArray::getSaveState).toArray(SWMRNibbleArray.SaveState[]::new);
        ListIterator<class_2852.class_9898> iterator = data.comp_2959().listIterator();
        while (iterator.hasNext()) {
            class_2852.class_9898 sectionData = (class_2852.class_9898)iterator.next();
            int index = sectionData.comp_2963() - WorldUtil.getMinLightSection((class_5539)serverLevel);
            byte[] blockRaw = blockNibbles[index] != null ? blockNibbles[index].data : null;
            byte[] skyRaw = skyNibbles[index] != null ? skyNibbles[index].data : null;
            iterator.set(new class_2852.class_9898(sectionData.comp_2963(), sectionData.comp_2964(), blockRaw != null ? new class_2804(blockRaw) : new class_2804(), skyRaw != null ? new class_2804(skyRaw) : new class_2804()));
        }
    }

    public static void saveLightHook(class_2852 data, class_2487 nbt) {
        try {
            SaveUtil.saveLightHookReal(data, nbt);
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(data.comp_2946()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void saveLightHookReal(class_2852 data, class_2487 tag) {
        int i;
        if (tag == null) {
            return;
        }
        int minSection = data.comp_2947() - 1;
        SWMRNibbleArray.SaveState[] blockNibbles = ((ExtendedSerializableChunkData)data).scalablelux$getBlockLight();
        SWMRNibbleArray.SaveState[] skyNibbles = ((ExtendedSerializableChunkData)data).scalablelux$getSkyLight();
        int maxSection = minSection + blockNibbles.length - 1;
        boolean lit = data.comp_2958();
        if (lit) {
            tag.method_10556("isLightOn", false);
        }
        class_2806 status = class_2806.method_12168((String)tag.method_10558("Status"));
        class_2487[] sections = new class_2487[maxSection - minSection + 1];
        class_2499 sectionsStored = tag.method_10554("sections", 10);
        for (i = 0; i < sectionsStored.size(); ++i) {
            class_2487 sectionStored = sectionsStored.method_10602(i);
            byte k = sectionStored.method_10571("Y");
            sectionStored.method_10551("BlockLight");
            sectionStored.method_10551("SkyLight");
            if (sectionStored.method_33133()) continue;
            sections[k - minSection] = sectionStored;
        }
        if (lit && status.method_12165(class_2806.field_12805)) {
            for (i = minSection; i <= maxSection; ++i) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i - minSection];
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i - minSection];
                if (blockNibble == null && skyNibble == null) continue;
                class_2487 section = sections[i - minSection];
                if (section == null) {
                    section = new class_2487();
                    section.method_10567("Y", (byte)i);
                    sections[i - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.method_10570("BlockLight", blockNibble.data);
                    }
                    section.method_10569(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.method_10570("SkyLight", skyNibble.data);
                }
                section.method_10569(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (class_2487 section : sections) {
            if (section == null) continue;
            sectionsStored.add((Object)section);
        }
        tag.method_10566("sections", (class_2520)sectionsStored);
        if (lit) {
            tag.method_10569(STARLIGHT_VERSION_TAG, 9);
        }
    }

    public static void prepareLoadLightHook(class_5539 levelHeightAccessor, class_2487 tag, class_2852 data) {
        try {
            SaveUtil.prepareLoadLightHookReal(levelHeightAccessor, tag, data);
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(data.comp_2946()) + ", light will be recalculated", ex);
        }
    }

    private static void prepareLoadLightHookReal(class_5539 world, class_2487 tag, class_2852 data) {
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        ((ExtendedSerializableChunkData)data).scalablelux$setLightCorrect(false);
        ((ExtendedSerializableChunkData)data).scalableLux$setActuallyCorrect(false);
        SWMRNibbleArray.SaveState[] blockLight = StarLightEngine.getFilledEmptySaveState(world);
        SWMRNibbleArray.SaveState[] skyLight = StarLightEngine.getFilledEmptySaveState(world);
        boolean lit = tag.method_10580("isLightOn") != null && tag.method_10550(STARLIGHT_VERSION_TAG) == 9;
        class_2806 status = data.comp_2950();
        if (lit && status.method_12165(class_2806.field_12805)) {
            class_2499 sections = tag.method_10554("sections", 10);
            for (int i = 0; i < sections.size(); ++i) {
                class_2487 sectionData = sections.method_10602(i);
                byte y = sectionData.method_10571("Y");
                blockLight[y - minSection] = sectionData.method_10573("BlockLight", 7) ? new SWMRNibbleArray.SaveState((byte[])sectionData.method_10547("BlockLight").clone(), sectionData.method_10550(BLOCKLIGHT_STATE_TAG)) : new SWMRNibbleArray.SaveState(null, sectionData.method_10550(BLOCKLIGHT_STATE_TAG));
                skyLight[y - minSection] = sectionData.method_10573("SkyLight", 7) ? new SWMRNibbleArray.SaveState((byte[])sectionData.method_10547("SkyLight").clone(), sectionData.method_10550(SKYLIGHT_STATE_TAG)) : new SWMRNibbleArray.SaveState(null, sectionData.method_10550(SKYLIGHT_STATE_TAG));
            }
        }
        ((ExtendedSerializableChunkData)data).scalablelux$setBlockLight(blockLight);
        ((ExtendedSerializableChunkData)data).scalablelux$setSkyLight(skyLight);
        ((ExtendedSerializableChunkData)data).scalableLux$setActuallyCorrect(lit);
    }

    public static void loadLightHook(class_1937 world, class_2852 data, class_2791 into) {
        try {
            SaveUtil.loadLightHookReal(world, data, into);
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(data.comp_2946()) + ", light will be recalculated", ex);
        }
    }

    private static void loadLightHookReal(class_1937 world, class_2852 data, class_2791 into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection((class_5539)world);
        int maxSection = WorldUtil.getMaxLightSection((class_5539)world);
        into.method_12020(false);
        SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])Arrays.stream(((ExtendedSerializableChunkData)data).scalablelux$getBlockLight()).map(state -> new SWMRNibbleArray(state.data, state.state)).toArray(SWMRNibbleArray[]::new);
        SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])Arrays.stream(((ExtendedSerializableChunkData)data).scalablelux$getSkyLight()).map(state -> new SWMRNibbleArray(state.data, state.state)).toArray(SWMRNibbleArray[]::new);
        boolean lit = ((ExtendedSerializableChunkData)data).scalablelux$getActuallyCorrect();
        ((ExtendedChunk)into).setBlockNibbles(blockNibbles);
        ((ExtendedChunk)into).setSkyNibbles(skyNibbles);
        into.method_12020(lit);
    }

    public static void loadVanillaLightHook(class_1937 world, class_2852 data, class_2791 into) {
        try {
            SaveUtil.loadVanillaLightHookReal(world, data, into);
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(data.comp_2946()) + ", light will be recalculated", ex);
        }
    }

    private static void loadVanillaLightHookReal(class_1937 world, class_2852 data, class_2791 into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection((class_5539)world);
        int maxSection = WorldUtil.getMaxLightSection((class_5539)world);
        class_2806 status = data.comp_2950();
        boolean lit = into.method_12038() && status.method_12165(class_2806.field_12805);
        into.method_12020(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight((class_5539)world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight((class_5539)world);
        if (lit) {
            List sectionData = data.comp_2959();
            int sectionDataSize = sectionData.size();
            for (int i = 0; i < sectionDataSize; ++i) {
                class_2852.class_9898 section = (class_2852.class_9898)sectionData.get(i);
                int y = section.comp_2963();
                if (section.comp_2965() != null) {
                    blockNibbles[y - minSection] = SWMRNibbleArray.fromVanilla(section.comp_2965());
                }
                if (section.comp_2966() == null) continue;
                skyNibbles[y - minSection] = SWMRNibbleArray.fromVanilla(section.comp_2966());
            }
            boolean fillWithZero = false;
            for (int i = skyNibbles.length - 1; i >= 0; --i) {
                if (!skyNibbles[i].isNullNibbleVisible()) {
                    fillWithZero = true;
                    continue;
                }
                if (!fillWithZero) continue;
                skyNibbles[i].setNonNull();
                skyNibbles[i].updateVisible();
            }
        }
        ((ExtendedChunk)into).setBlockNibbles(blockNibbles);
        ((ExtendedChunk)into).setSkyNibbles(skyNibbles);
        into.method_12020(lit);
    }

    private SaveUtil() {
    }
}

