/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1163;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_811;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.WeatherParticle;

public class ShrubParticle
extends WeatherParticle {
    protected ShrubParticle(class_638 level, double x, double y, double z) {
        super(level, x, y, z);
        this.field_17867 = 0.5f;
        this.field_3844 = ModConfig.CONFIG.shrub.gravity;
        this.field_3852 = level.method_8546() ? (double)ModConfig.CONFIG.shrub.stormWindStrength : (double)ModConfig.CONFIG.shrub.windStrength;
        double d = this.field_3850 = level.method_8546() ? (double)ModConfig.CONFIG.shrub.stormWindStrength : (double)ModConfig.CONFIG.shrub.windStrength;
        if (ModConfig.CONFIG.dust.spawnOnGround) {
            this.field_3869 = 0.1f;
        }
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8689);
        class_10444 renderState = new class_10444();
        class_2680 blockState = level.method_8320(level.method_8598(class_2902.class_2903.field_13197, (class_2338)this.pos));
        if (blockState.method_26164(class_3481.field_44469)) {
            if (!blockState.method_26164(class_3481.field_20341)) {
                itemStack = blockState.method_26204().method_8389().method_7854();
                class_310.method_1551().method_65386().method_65598(renderState, itemStack, class_811.field_4315, false, (class_1937)level, null, 0);
                class_1058 particleIcon = renderState.field_55340[0].field_55346.method_4711();
                try {
                    String string;
                    class_2960 resourceLocation = class_2960.method_60654((String)(particleIcon.method_45851().method_45816().method_12836() + ":models/" + particleIcon.method_45851().method_45816().toString().substring(particleIcon.method_45851().method_45816().method_12836().toString().length() + 1) + ".json"));
                    class_3298 resource = class_310.method_1551().method_1478().getResourceOrThrow(resourceLocation);
                    try (InputStream inputStream = resource.method_14482();){
                        string = new String(inputStream.readAllBytes());
                    }
                    if (string.contains("tint")) {
                        int colorInt = class_1163.method_4966((class_1920)level, (class_2338)this.pos);
                        Color color = new Color(colorInt);
                        this.method_3084((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                    }
                }
                catch (IOException e) {
                    itemStack = new class_1799((class_1935)class_1802.field_8689);
                }
            }
        } else if ((double)level.field_9229.method_43057() < 0.9) {
            this.method_3085();
        }
        class_310.method_1551().method_65386().method_65598(renderState, itemStack, class_811.field_4315, false, (class_1937)level, null, 0);
        this.method_18141(renderState.field_55340[0].field_55346.method_4711());
    }

    @Override
    public void method_3070() {
        super.method_3070();
        this.removeIfObstructed();
        if (!this.field_3851.method_8316((class_2338)this.pos).method_15769()) {
            this.shouldFadeOut = true;
            this.field_3844 = 0.0f;
        } else {
            this.field_3852 = this.field_3851.method_8546() ? (double)ModConfig.CONFIG.shrub.stormWindStrength : (double)ModConfig.CONFIG.shrub.windStrength;
            this.field_3850 = this.field_3851.method_8546() ? (double)ModConfig.CONFIG.shrub.stormWindStrength : (double)ModConfig.CONFIG.shrub.windStrength;
        }
        this.field_3857 = this.field_3839;
        this.field_3839 += ModConfig.CONFIG.shrub.rotationAmount;
        if (this.field_3845) {
            this.field_3869 = ModConfig.CONFIG.shrub.bounciness;
        }
    }

    @Override
    public void fadeIn() {
        if (this.field_3866 < 10) {
            this.field_3841 = (float)this.field_3866 * 1.0f / 10.0f;
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17827;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickPercentage) {
        Vector3f camPos = camera.method_19326().method_46409();
        float x = (float)(class_3532.method_16436((double)tickPercentage, (double)this.field_3858, (double)this.field_3874) - (double)camPos.x);
        float y = (float)(class_3532.method_16436((double)tickPercentage, (double)this.field_3838, (double)this.field_3854) - (double)camPos.y);
        float z = (float)(class_3532.method_16436((double)tickPercentage, (double)this.field_3856, (double)this.field_3871) - (double)camPos.z);
        float angle = (float)Math.atan2((double)this.field_3852, (double)this.field_3850);
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotateY(angle);
        Quaternionf quat1 = new Quaternionf(new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
        Quaternionf quat2 = new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f));
        quat1.mul((Quaternionfc)quaternion).rotateX(class_3532.method_16439((float)tickPercentage, (float)this.field_3857, (float)this.field_3839));
        quat2.mul((Quaternionfc)quaternion).rotateZ(class_3532.method_16439((float)tickPercentage, (float)this.field_3857, (float)this.field_3839));
        quat1 = this.flipItTurnwaysIfBackfaced(quat1, new Vector3f(x, y, z));
        quat2 = this.flipItTurnwaysIfBackfaced(quat2, new Vector3f(x, y, z));
        this.method_60374(vertexConsumer, quat1, x, y, z, tickPercentage);
        this.method_60374(vertexConsumer, quat2, x, y, z, tickPercentage);
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        public DefaultFactory(class_4002 provider) {
        }

        public class_703 createParticle(class_2400 parameters, class_638 level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ShrubParticle(level, x, y, z);
        }
    }
}

