/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7833;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRainClient;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.WeatherParticle;

public class RainParticle
extends WeatherParticle {
    protected RainParticle(class_638 level, double x, double y, double z) {
        super(level, x, y, z);
        if (ModConfig.CONFIG.compat.biomeTint) {
            TextureUtil.applyWaterTint(this, level, (class_2338)this.pos);
        }
        this.field_17867 = ModConfig.CONFIG.rain.size;
        this.field_3844 = ModConfig.CONFIG.rain.gravity;
        this.field_3869 = -this.field_3844;
        this.method_18141(class_310.method_1551().field_1713.field_18301.method_4608(class_2960.method_60655((String)"particlerain", (String)("rain" + this.field_3840.method_43048(4)))));
        this.field_3852 = level.method_8546() ? (double)(this.field_3844 * ModConfig.CONFIG.rain.stormWindStrength) : (double)(this.field_3844 * ModConfig.CONFIG.rain.windStrength);
        if (ModConfig.CONFIG.compat.yLevelWindAdjustment) {
            this.field_3852 *= RainParticle.yLevelWindAdjustment(y);
        }
        this.field_3850 = this.field_3852;
        this.field_3847 = ModConfig.CONFIG.perf.particleRadius * 5;
        class_243 vec3 = class_310.method_1551().field_1719.method_19538();
        this.field_3839 = (float)(org.joml.Math.atan2((double)(x - vec3.field_1352), (double)(z - vec3.field_1350)) + 1.5707963705062866);
    }

    @Override
    public void fadeIn() {
        if (this.field_3866 < 20) {
            this.field_3841 = org.joml.Math.clamp((float)0.0f, (float)ModConfig.CONFIG.rain.opacity, (float)((float)this.field_3866 * 1.0f / 20.0f));
        }
    }

    @Override
    public void method_3070() {
        class_243 raycastEnd;
        class_243 raycastStart;
        class_3965 hit;
        super.method_3070();
        if (this.field_3845 || !this.field_3851.method_8316((class_2338)this.pos).method_15769()) {
            if ((ModConfig.CONFIG.effect.doSplashParticles || ModConfig.CONFIG.effect.doSmokeParticles || ModConfig.CONFIG.effect.doRippleParticles) && class_310.method_1551().field_1719.method_19538().method_1022(this.pos.method_46558()) < (double)ModConfig.CONFIG.perf.particleRadius - (double)ModConfig.CONFIG.perf.particleRadius / 2.0) {
                for (int i = 0; i < ModConfig.CONFIG.rain.impactEffectAmount; ++i) {
                    class_243 spawnPos = class_243.method_49273((class_2382)this.pos, (double)(this.field_3840.method_43057() * 3.0f - 1.0f), (double)0.0, (double)(this.field_3840.method_43057() * 3.0f - 1.0f));
                    double d = this.field_3840.method_43058();
                    double e = this.field_3840.method_43058();
                    class_2338 blockPos = class_2338.method_49638((class_2374)spawnPos);
                    class_2680 blockState = this.field_3851.method_8320(blockPos);
                    class_3610 fluidState = this.field_3851.method_8316(blockPos);
                    class_265 voxelShape = blockState.method_26220((class_1922)this.field_3851, blockPos);
                    double voxelHeight = voxelShape.method_1102(class_2350.class_2351.field_11052, d, e);
                    double fluidHeight = fluidState.method_15763((class_1922)this.field_3851, blockPos);
                    double height = Math.max(voxelHeight, fluidHeight);
                    class_243 raycastStart2 = new class_243(this.field_3874, this.field_3854, this.field_3871);
                    class_243 raycastEnd2 = new class_243(spawnPos.field_1352, this.field_3854, spawnPos.field_1350);
                    class_3965 hit2 = this.field_3851.method_17742(new class_3959(raycastStart2, raycastEnd2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                    class_241 raycastHit = new class_241((float)hit2.method_17784().field_1352, (float)hit2.method_17784().field_1350);
                    if (height == 0.0) continue;
                    class_241 class_2412 = new class_241((float)spawnPos.field_1352, (float)spawnPos.field_1350);
                    if (!((double)raycastHit.method_35589(class_2412) < 0.01)) continue;
                    if (ModConfig.CONFIG.effect.doRippleParticles && fluidState.method_33659((class_3611)class_3612.field_15910)) {
                        if (height == 1.0) continue;
                        class_310.method_1551().field_1713.method_3056((class_2394)ParticleRainClient.RIPPLE, spawnPos.field_1352, spawnPos.field_1351 + height, spawnPos.field_1350, 0.0, 0.0, 0.0);
                        if (!this.field_3851.method_8546() || !ModConfig.CONFIG.effect.doSplashParticles) continue;
                        class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11242, spawnPos.field_1352, spawnPos.field_1351 + height, spawnPos.field_1350, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (ModConfig.CONFIG.effect.doSmokeParticles && (blockState.method_26164(class_3481.field_25588) || blockState.method_26164(class_3481.field_23209))) {
                        class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11251, spawnPos.field_1352, spawnPos.field_1351 + height, spawnPos.field_1350, 0.0, 0.0, 0.0);
                        if (!this.field_3851.method_8546()) continue;
                        class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11237, spawnPos.field_1352, spawnPos.field_1351 + height, spawnPos.field_1350, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!ModConfig.CONFIG.effect.doSplashParticles) continue;
                    class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11242, spawnPos.field_1352, spawnPos.field_1351 + height, spawnPos.field_1350, 0.0, 0.0, 0.0);
                }
            }
            this.method_3085();
        } else if (this.removeIfObstructed() && (hit = this.field_3851.method_17742(new class_3959(raycastStart = new class_243(this.field_3874, this.field_3854, this.field_3871), raycastEnd = new class_243(this.field_3874 + (double)ModConfig.CONFIG.rain.windStrength, this.field_3854, this.field_3871 + (double)ModConfig.CONFIG.rain.windStrength), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()))).method_17783().equals((Object)class_239.class_240.field_1332)) {
            if (ModConfig.CONFIG.effect.doStreakParticles && class_310.method_1551().field_1719.method_19538().method_1022(this.pos.method_46558()) < (double)ModConfig.CONFIG.perf.particleRadius - (double)ModConfig.CONFIG.perf.particleRadius / 2.0 && WeatherParticleManager.canHostStreaks(this.field_3851.method_8320(hit.method_17777()))) {
                class_310.method_1551().field_1713.method_3056((class_2394)ParticleRainClient.STREAK, this.field_3874, this.field_3854, this.field_3871, (double)hit.method_17780().method_10161(), 0.0, 0.0);
                class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11242, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
            }
            this.method_3085();
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickPercentage) {
        Vector3f camPos = camera.method_19326().method_46409();
        float x = (float)(class_3532.method_16436((double)tickPercentage, (double)this.field_3858, (double)this.field_3874) - (double)camPos.x);
        float y = (float)(class_3532.method_16436((double)tickPercentage, (double)this.field_3838, (double)this.field_3854) - (double)camPos.y);
        float z = (float)(class_3532.method_16436((double)tickPercentage, (double)this.field_3856, (double)this.field_3871) - (double)camPos.z);
        Vector3f delta = new Vector3f((float)this.field_3852, (float)this.field_3869, (float)this.field_3850);
        float angle = org.joml.Math.acos((float)delta.normalize().y);
        Vector3f axis = new Vector3f(-delta.z(), 0.0f, delta.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        quaternion.mul((Quaternionfc)class_7833.field_40715.rotation(this.field_3839));
        quaternion = this.flipItTurnwaysIfBackfaced(quaternion, new Vector3f(x, y, z));
        this.method_60374(vertexConsumer, quaternion, x, y, z, tickPercentage);
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        public DefaultFactory(class_4002 provider) {
        }

        public class_703 createParticle(class_2400 parameters, class_638 level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new RainParticle(level, x, y, z);
        }
    }
}

