/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.joml.Math;
import pigcart.particlerain.config.ModConfig;

public class TextureUtil {
    public static IntUnaryOperator desaturateOperation = rgba -> {
        Color col = new Color(rgba, true);
        int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
        return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
    };

    public static void applyWaterTint(class_4003 particle, class_638 clientLevel, class_2338 blockPos) {
        Color waterColor = new Color(class_1163.method_4961((class_1920)clientLevel, (class_2338)blockPos));
        Color fogColor = new Color(((class_1959)clientLevel.method_23753(blockPos).comp_349()).method_24376());
        float rCol = class_3532.method_16439((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getRed(), (float)fogColor.getRed()) / 255.0f;
        float gCol = class_3532.method_16439((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getGreen(), (float)fogColor.getGreen()) / 255.0f;
        float bCol = class_3532.method_16439((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getBlue(), (float)fogColor.getBlue()) / 255.0f;
        particle.method_3084(rCol, gCol, bCol);
    }

    public static class_1011 loadTexture(class_2960 resourceLocation) throws IOException {
        class_1011 nativeImage;
        class_3298 resource = class_310.method_1551().method_1478().getResourceOrThrow(resourceLocation);
        try (InputStream inputStream = resource.method_14482();){
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static class_7764 splitImage(class_1011 image, int segment, String id) {
        int size = image.method_4307();
        class_1011 sprite = new class_1011(size, size, false);
        image.method_47594(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return new class_7764(class_2960.method_60655((String)"particlerain", (String)(id + segment)), new class_7771(size, size), sprite, new class_7368.class_8622().method_52447());
    }

    public static int getRippleResolution(List<class_7764> contents) {
        if (ModConfig.CONFIG.ripple.useResourcepackResolution) {
            class_2960 resourceLocation = class_2960.method_60656((String)"big_smoke_0");
            for (class_7764 spriteContents : contents) {
                if (!spriteContents.method_45816().equals((Object)resourceLocation)) continue;
                if (spriteContents.method_45807() < 256) {
                    return spriteContents.method_45807();
                }
                return 256;
            }
        }
        if (ModConfig.CONFIG.ripple.resolution < 4) {
            ModConfig.CONFIG.ripple.resolution = 4;
        }
        if (ModConfig.CONFIG.ripple.resolution > 256) {
            ModConfig.CONFIG.ripple.resolution = 256;
        }
        return ModConfig.CONFIG.ripple.resolution;
    }

    public static class_7764 generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        class_1011 image = new class_1011(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        TextureUtil.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return new class_7764(class_2960.method_60655((String)"particlerain", (String)("ripple" + i)), new class_7771(size, size), image, new class_7368.class_8622().method_52447());
    }

    public static void generateBresenhamCircle(class_1011 image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        TextureUtil.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            TextureUtil.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    static void drawCirclePixel(int xc, int yc, int x, int y, class_1011 img, int col) {
        img.method_61941(xc + x, yc + y, col);
        img.method_61941(xc - x, yc + y, col);
        img.method_61941(xc + x, yc - y, col);
        img.method_61941(xc - x, yc - y, col);
        img.method_61941(xc + y, yc + x, col);
        img.method_61941(xc - y, yc + x, col);
        img.method_61941(xc + y, yc - x, col);
        img.method_61941(xc - y, yc - x, col);
    }
}

