/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import pigcart.particlerain.WeatherBlockManager;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.DustMoteParticle;
import pigcart.particlerain.particle.DustParticle;
import pigcart.particlerain.particle.FogParticle;
import pigcart.particlerain.particle.GroundFogParticle;
import pigcart.particlerain.particle.RainParticle;
import pigcart.particlerain.particle.RippleParticle;
import pigcart.particlerain.particle.ShrubParticle;
import pigcart.particlerain.particle.SnowParticle;
import pigcart.particlerain.particle.StreakParticle;

public class ParticleRainClient
implements ClientModInitializer {
    public static final String MOD_ID = "particlerain";
    public static class_2400 RAIN;
    public static class_2400 SNOW;
    public static class_2400 DUST_MOTE;
    public static class_2400 DUST;
    public static class_2400 FOG;
    public static class_2400 GROUND_FOG;
    public static class_2400 SHRUB;
    public static class_2400 RIPPLE;
    public static class_2400 STREAK;
    public static class_3414 WEATHER_SNOW;
    public static class_3414 WEATHER_SNOW_ABOVE;
    public static class_3414 WEATHER_SANDSTORM;
    public static class_3414 WEATHER_SANDSTORM_ABOVE;

    public void onInitializeClient() {
        ModConfig.loadConfig();
        RAIN = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"rain"), (Object)FabricParticleTypes.simple((boolean)true));
        SNOW = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"snow"), (Object)FabricParticleTypes.simple((boolean)true));
        DUST_MOTE = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"dust_mote"), (Object)FabricParticleTypes.simple((boolean)true));
        DUST = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"dust"), (Object)FabricParticleTypes.simple((boolean)true));
        SHRUB = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"shrub"), (Object)FabricParticleTypes.simple((boolean)true));
        FOG = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"fog"), (Object)FabricParticleTypes.simple((boolean)true));
        GROUND_FOG = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"ground_fog"), (Object)FabricParticleTypes.simple((boolean)true));
        RIPPLE = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"ripple"), (Object)FabricParticleTypes.simple((boolean)true));
        STREAK = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"streak"), (Object)FabricParticleTypes.simple((boolean)true));
        WEATHER_SNOW = ParticleRainClient.createSoundEvent("weather.snow");
        WEATHER_SNOW_ABOVE = ParticleRainClient.createSoundEvent("weather.snow.above");
        WEATHER_SANDSTORM = ParticleRainClient.createSoundEvent("weather.sandstorm");
        WEATHER_SANDSTORM_ABOVE = ParticleRainClient.createSoundEvent("weather.sandstorm.above");
        ParticleFactoryRegistry.getInstance().register((class_2396)RAIN, RainParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SNOW, SnowParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)DUST_MOTE, DustMoteParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)DUST, DustParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SHRUB, ShrubParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)FOG, FogParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)GROUND_FOG, GroundFogParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)RIPPLE, RippleParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)STREAK, StreakParticle.DefaultFactory::new);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ClientPlayConnectionEvents.JOIN.register(this::onJoin);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, buildContext) -> {
            LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)ClientCommandManager.literal((String)MOD_ID).executes(ctx -> {
                class_638 level = class_310.method_1551().field_1687;
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Particle count: %d/%d", WeatherParticleManager.particleCount, ModConfig.CONFIG.perf.maxParticleAmount)));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Fog density: %d/%d", WeatherParticleManager.fogCount, ModConfig.CONFIG.groundFog.density)));
                class_2338 blockPos = class_2338.method_49638((class_2374)((FabricClientCommandSource)ctx.getSource()).getPlayer().method_19538());
                class_6880 holder = level.method_23753(blockPos);
                String biomeStr = (String)holder.method_40229().map(resourceKey -> resourceKey.method_29177().toString(), biome -> "[unregistered " + String.valueOf(biome) + "]");
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Biome: " + biomeStr, new Object[0])));
                class_1959.class_1963 precipitation = ((class_1959)holder.comp_349()).method_48162(blockPos, level.method_8615());
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Precipitation: " + String.valueOf(precipitation), new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Base Temp: " + ((class_1959)holder.comp_349()).method_8712(), new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("has puddle: " + WeatherBlockManager.hasPuddle(level, blockPos), new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("standing on full block: " + level.method_8320(blockPos.method_10074()).method_26234((class_1922)level, blockPos.method_10074()), new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("is exposed: " + WeatherBlockManager.isExposed(level, blockPos), new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Puddle target level: " + WeatherBlockManager.puddleTargetLevel, new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Puddle threshold: " + WeatherBlockManager.puddleThreshold, new Object[0])));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("fluid amount: " + level.method_8316(blockPos).method_15761(), new Object[0])));
                return 0;
            });
            dispatcher.register(cmd);
        });
    }

    private void onJoin(class_634 clientPacketListener, PacketSender packetSender, class_310 minecraft) {
        WeatherBlockManager.puddleThreshold = 0;
    }

    private void onTick(class_310 client) {
        if (!client.method_1493() && client.field_1687 != null && client.method_1560() != null) {
            WeatherParticleManager.tick(client.field_1687, client.method_1560());
            WeatherBlockManager.tick(client.field_1687);
        }
    }

    private static class_3414 createSoundEvent(String name) {
        class_2960 id = class_2960.method_60655((String)MOD_ID, (String)name);
        return class_3414.method_47908((class_2960)id);
    }
}

